﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="seallist.aspx.cs" Inherits="LawOA.Web.lawoa.seallist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>
    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i> 退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("seallist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>印章使用管理</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">印章使用管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body">
<div class="chartclass">
<a href="sealedit.aspx?t=add" class="btn btn-default" data-toggle="modal" data-target="#modal"><i class="fa fa-plus-circle"></i> 申请使用印章</a>
<%= GetTopNavHtml() %>
</div>
</div>　 　 　 　 　 　　
      
<div class="box box-body"<%= GetRH("c") == "sygl" ? "":" style='display:none'" %>>
<table width="100%">
  <tbody>
    <tr>
      <td style="line-height:220%;">
<form action="seallist.aspx" method="get"> 
<input type="hidden" name="action" value="search" />
<input type="hidden" name="c" value="sygl" />
<select class="myinputso" name="lawyerid">
  <option value="-1">按律师查找</option>
  <%= OutputLawyerOptions(0) %>
</select>
<select class="myinputso" name="cate">
  <option value="">按分类查找</option>
  <%= OutputSealCatOptions("") %>
</select>
<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> 查询</button>
</form>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="box">

<div class="box-body" style="text-align:center;display:none">
请点击表头项进行排序 
</div>
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                   <th style="text-align:center">操作</th>
                    <th>ID号</th>
                    <th>分类</th>
                    <th>申请律师</th>
                    <th>申请时间</th>
                    <th>申请理由</th>
                    <th>审批情况</th>
                    <th>审批人</th>
                    <th>审批时间</th>
                    <th>不通过理由</th>
                    <th>备注</th>						
                  </tr>
                  </thead>
                  <tbody>
                  <% foreach (var info in sealList){ %>
                  <tr>
                  <td align="left" valign="middle" class="tablenowrap">
<% if (loginLawyer.userlevel >= 10)
    { %>
<a class="btn btn-success btn-xs" data-toggle="modal" href="seallist.aspx?t=tgsp&sid=<%= info.sid %>" title="通过审批" onclick="return confirm('确认通过审批？')"><i class="fa fa-check"></i> 通过</a>
<a class="btn btn-warning btn-xs" data-toggle="modal" href="sealyesno.aspx?t=no&sid=<%= info.sid %>" title="否决审批"><i class="fa fa-remove"></i> 否决</a>
<a class="btn btn-danger btn-xs"  href="seallist.aspx?t=del&sid=<%= info.sid %>" onclick="return confirm('删除印章后不能恢复，确认删除？')"><i class="fa fa-trash-o"></i> 删除</a> 
<% } %>
                    </td>
                    <td><%= info.sid %></td>
                    <td><%= info.sealcate %></td>
                    <td><a data-toggle="modal" data-target="#modal" href="lawyerview.aspx?lid=<%= info.applicantlawyerid %>"><%= GetLawyerName(info.applicantlawyerid) %></a></td>
                    <td><%= info.createtime %></td>
                    <td><a href="sealview.aspx?sid=<%= info.sid %>" data-target="#modal" data-toggle="modal"><%= info.title %></a></td>
                    <td><%= GetApprovedStatus(info.approved) %></td>
                    <td><a data-toggle="modal" data-target="#modal" href="lawyerview.aspx?lid=<%= info.approverid %>"><%= GetLawyerName(info.approverid) %></a></td>
                    <td><%= info.approved > 0 ? info.approvedtime.ToString() : "" %></td>
                    <td><%= info.approvecomment %></td>
                    <td><%= info.remark %></td>
                  </tr>
                  <% } %>                  
                  </tbody>
                </table>
              </div>
            </div>
            <div class="box-footer clearfix">
                <%= PagerHtml %>
            </div>
        </div>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:80%; margin:2% auto 0 auto; max-width:1000px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
