﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="vacateyesno.aspx.cs" Inherits="LawOA.Web.lawoa.vacateyesno" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("vacatelist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>请假申请审批</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">请假申请审批</li>
      </ol>
    </section>
<section class="content container-fluid">      
<div class="box box-body casepage">
<form action="?action=save&t=<%= paget %>&vid=<%= pageid %>" method="post">
<!-- 注意如下一个ul为一个段落 -->
<ul>
<li>申请人：<%= pageInfo.lawyername %></li>
<li>请假类型：<%= pageInfo.vcate %></li>
<li>请假时间：<%= pageInfo.startdate.ToString("yyyy/MM/dd") + (pageInfo.startapm=="am"?"上午":"下午") + "-" + pageInfo.enddate.ToString("yyyy/MM/dd") + (pageInfo.endapm=="am"?"上午":"下午") %></li>
<li>请假天数：<%= pageInfo.daynums %></li>
<li>请假原因：<%= pageInfo.reason %></li>
<li>审批状态：<%= paget == "no" ? "否决审批" : "通过审批" %></li>
<li><%= paget == "no" ? "否决审批" : "通过审批" %>评语：<textarea class="myinput" name="approvecomment" style="width:70%;"></textarea> </li>
</ul> 

<p style="text-align:center">
<button type="submit" class="btn btn-danger"><%= paget == "no" ? "<i class='fa fa-remove'></i>否决审批" : "<i class='fa fa-check'></i>通过审批" %></button>
</p>
</form>
 </div>

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:90%; margin:5% auto 0 auto; max-width:1600px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
