﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using EnterpriseNET.BusinessLogicLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

public partial class enet0769_admin_manage_subclass : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //加载
        if (!IsPostBack)
        {
            //绑定数据
            bindData();

            //绑定数据产品大类
            DataView dv = MajorClass.QueryMajorClass();
            MajorID.DataValueField = dv.Table.Columns[0].Caption.ToString();
            MajorID.DataTextField = dv.Table.Columns[2].Caption.ToString();
            MajorID.DataSource = dv;
            MajorID.DataBind();
        } 
    }

    void bindData()
    {
        DataView dvlist = SubClass.QuerySubClass();
        AspNetPager1.RecordCount = dvlist.Table.Rows.Count;
        //Session["dvlist"] = dvlist;

        PagedDataSource pds = new PagedDataSource();
        pds.AllowPaging = true;
        pds.PageSize = AspNetPager1.PageSize;
        pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
        //pds.DataSource = (DataView)Session["dvlist"];
        pds.DataSource = dvlist;
        GridView1.DataSource = pds;
        GridView1.DataBind();
    }


    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindData();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        Hashtable ht = new Hashtable();
        ht.Add("MajorID", SqlStringConstructor.GetQuotedString(MajorID.SelectedItem.Value));
        ht.Add("SubName", SqlStringConstructor.GetQuotedString(SubName.Text));
        //ht.Add("SubNameEn", SqlStringConstructor.GetQuotedString(SubNameEn.Text));
        ht.Add("SeoTitle", SqlStringConstructor.GetQuotedString(SeoTitle.Text));
        //ht.Add("SeoTitleEn", SqlStringConstructor.GetQuotedString(SeoTitleEn.Text));
        ht.Add("SeoKeywords", SqlStringConstructor.GetQuotedString(SeoKeywords.Text));
        //ht.Add("SeoKeywordsEn", SqlStringConstructor.GetQuotedString(SeoKeywordsEn.Text));
        ht.Add("SeoDesc", SqlStringConstructor.GetQuotedString(SeoDesc.Text));
        //ht.Add("SeoDescEn", SqlStringConstructor.GetQuotedString(SeoDescEn.Text));
        ht.Add("SubSortID", SqlStringConstructor.GetQuotedString(SubSortID.Text));

        SubClass subClass = new SubClass();
        subClass.Add(ht);

        Response.Redirect("manage_subclass.aspx");
    }
}
