﻿<%@ Page Language="C#" AutoEventWireup="true"  CodeFile="default.aspx.cs" Inherits="_Default" EnableViewState="false" %>
<%@ Register src="UserControls/top.ascx" tagname="top" tagprefix="uc1" %>
<%@ Register src="UserControls/adv.ascx" tagname="adv" tagprefix="uc2" %>
<%@ Register src="UserControls/bottom.ascx" tagname="bottom" tagprefix="uc4" %>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><%#SeoTitle%> - <%#CompanyName%></title>
<meta name="keywords" content="<%#SeoKeywords%>" />
<meta name="description" content="<%#SeoDesc%>" />
<link rel="shortcut icon" href="/skin/images/logo.ico" />
<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css">
<link href="css/default.css" rel="stylesheet" type="text/css">
<link href="css/style.css" rel="stylesheet" type="text/css">
<link href="css/plugin.css" rel="stylesheet" type="text/css">
<script src="js/jquery-3.3.1.min.js"></script>
</head>

<body>
    <form id="form1" runat="server"> 
   <uc1:top ID="top1" runat="server" />
   <uc2:adv ID="adv1" runat="server" />


   <!-- product starts -->
     <section class="rooms">
        <div class="container">
            <div class="section-title">
                <h2><a href="product____1.html">产品中心</a></h2>
                <p>多年光伏、太阳能发电经验，可按您的需求定制，专业引领新潮流</p>
            </div>
            <div class="room-outer">
                <div class="row">
                <asp:Repeater ID="ProductListR" runat="server">
                <ItemTemplate>
                    <div class="col-md-4 col-sm-6 col-xs-12 mar-bottom-30">
                        <div class="room-item">
                            <div class="">
                                <a title="<%#Eval("ProductName") %>" href="product_detail-<%#Eval("ProductID")%>.html"><img src="upimage/<%#Eval("PicPathSmall")%>" alt="<%#Eval("ProductName") %>"></a>
                            </div>
                            <div class="room-content">
                                <div class="room-title">
                                    <h4 class="text-center"><a title="<%#Eval("ProductName") %>" href="product_detail-<%#Eval("ProductID")%>.html"><%#cutstr(Eval("ProductName").ToString(), 22)%></a></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                     </ItemTemplate>
                </asp:Repeater>
                </div>
            </div>
            <div class="section-btn">
                <a href="product____1.html" class="btn btn-black mar-right-10">&nbsp;查看更多 <i class="fas fa-angle-double-right"></i></a>
            </div>
        </div>
    </section>
    <!-- product Ends -->


    <!-- About Us Start -->
    <section class="about-us">
        <div class="container">
            <div class="section-title">
                <h2><a href="about_1.html">关于我们</a></h2>
                <p>专业高效、精诚协作、敬业创新</p>
            </div>
            <div class="about-outer">
                <div class="row">
                <div class="col-md-6 col-sm-6 col-xs-12">
                    <div class="about-content">
                            <a href="about_1.html">
                            <h3 class="mar-bottom-30">新能源公司</h3>
                            <p>本公司是一家专注推广太阳能光伏发电和储能系统的创新型企业，业务范围涵盖：太阳能光伏及储能系统工程，设计咨询服务，供货安装服务，运维服务。产品涉及太阳能光伏组件、逆变器、控制器、储能电池、新能源汽车充电桩……等。公司业务遍及全国各地。</p>
                            <p>我们一直以“客户至上、质量保障”为宗旨，秉承“专业高效、精诚协作、敬业创新”的经营理念，为客户提供优质的服务。放眼未来，我们将进一步整合现有资源，吸纳、学习先进理念，强调工艺和材料研发，不断延展、完善服务产业链，提升综合服务水平，促进能源、经济与环境的和谐发展。</p>
                            <p>企业管理理念：结果导向、系统思考、专业专注、团队信任、发挥优势</p>
                            <p>企业定位：专业光伏太阳能企业 </p>
                            </a>
                            <a class="btn btn-orange mar-top-10" href="about_1.html">&nbsp;查看更多 <i class="fas fa-angle-double-right"></i></a>
                        </div>
</div>
<div class="col-md-6 col-sm-6 col-xs-12">
	<img src="images/about1.jpg" alt="about us" /><br />
</div>

                   
                </div>
            </div>
        </div>
    </section>
    <!-- About Us Ends -->
    
     <!-- Team Starts -->
    <section class="services">
        <div class="container">
            <div class="section-title">
                <h2><a href="factorypic_1.html">项目案例</a></h2>
                <p>丰富的项目案例，专业的工程师团队</p>
            </div>
            <div class="service-outer">
                <div class="row">

                    <asp:Repeater ID="FacPicList" runat="server">
                     <ItemTemplate> 
                    <div class="col-md-4 col-sm-12 col-xs-12">
                        <div class="service-item">
                            <div class="service-image">
                                <a title="<%#Eval("FacPicTitle") %>" href="facpic_detail-<%#Eval("FacPicID") %>.html"><img src="upimage/<%#Eval("PicPathSmall")%>" alt="<%#Eval("FacPicTitle") %>"></a>
                            </div>
                            <div class="service-content">
                                <h4><a title="<%#Eval("FacPicTitle") %>" href="facpic_detail-<%#Eval("FacPicID") %>.html"><%#cutstr(Eval("FacPicTitle").ToString(), 22)%></a></h4>
                            </div>
                        </div>
                    </div>
                      </ItemTemplate>
                    </asp:Repeater>
                    
                </div>
            </div>
        </div>
    </section>
    <!-- Team Ends -->

    <!-- News Starts -->
    <section class="news">
        <div class="container">
            <div class="section-title">
                <h2><a href="news__1.html">资讯中心</a></h2>
                <p>新能源行业资讯，了解行业发展趋势</p>
            </div>
            <div class="news-outer">
                <div class="row">

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="news-item">
                            <div class="news-image">
                                <a href="<%#n1Link%>"><asp:Image ID="NewsPic1" runat="server" /></a>
                            </div>
                            <div class="news-content">
                                <p class="date mar-bottom-5"><%#n1AddTime%></p>
                                <h4><a href="<%#n1Link%>" title="<%#n1Title%>"><%#cutstr(n1Title.ToString(), 15)%></a></h4>
                                <p><a href="<%#n1Link%>"><%#cutstr(n1Desc,52)%>...</a></p>
                                <a href="news_1_1.html">more <i class="fas fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="news-item">
                            <div class="news-image">
                                <a href="<%#n2Link%>"><asp:Image ID="NewsPic2" runat="server" /></a>
                            </div>
                            <div class="news-content">
                                <p class="date mar-bottom-5"><%#n2AddTime%></p>
                                <h4><a href="<%#n2Link%>" title="<%#n2Title%>"><%#cutstr(n2Title.ToString(), 15)%></a></h4>
                                <p><a href="<%#n2Link%>"><%#cutstr(n2Desc,52)%>...</a></p>
                                <a href="news_2_1.html">more <i class="fas fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="news-item">
                            <div class="news-image">
                                <a href="<%#n3Link%>"><asp:Image ID="NewsPic3" runat="server" /></a>
                            </div>
                            <div class="news-content">
                                <p class="date mar-bottom-5"><%#n3AddTime%></p>
                                <h4><a href="<%#n3Link%>" title="<%#n3Title%>"><%#cutstr(n3Title.ToString(), 15)%></a></h4>
                                <p><a href="<%#n3Link%>"><%#cutstr(n3Desc,52)%>...</a></p>
                                <a href="news_3_1.html">more <i class="fas fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="section-btn">
                <a href="news__1.html" class="btn btn-black mar-right-10">&nbsp;查看更多 <i class="fas fa-angle-double-right"></i></a>
            </div>
        </div>
    </section>
    <!-- News Ends -->

     <div class="container">
        <div style="margin-bottom:8px;">
        友情链接：<asp:Repeater ID="FriendLinkList" runat="server">
      <ItemTemplate>    
<a href="<%#Eval("LinkUrl") %>" target="_blank" title="<%#Eval("LinkKeyword") %>"><%#Eval("LinkKeyword")%></a>&nbsp;&nbsp;
      </ItemTemplate>
    </asp:Repeater>
     </div>
     </div>

    

    <uc4:bottom ID="bottom1" runat="server" />

    </form>
</body>
</html>