﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="news.aspx.cs" Inherits="news" EnableViewState="false" %>
<%@ Register src="UserControls/top.ascx" tagname="top" tagprefix="uc1" %>
<%@ Register src="UserControls/adv3.ascx" tagname="adv1" tagprefix="uc2" %>
<%@ Register src="UserControls/bottom.ascx" tagname="bottom" tagprefix="uc4" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta charset="utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title><%#SeoTitle%> - <%#CompanyName%></title>
<meta name="keywords" content="<%#SeoKeywords%>" />
<meta name="description" content="<%#SeoDesc%>" />
<link rel="shortcut icon" href="/skin/images/logo.ico" />
<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css">
<link href="css/default.css" rel="stylesheet" type="text/css">
<link href="css/style.css" rel="stylesheet" type="text/css">
<link href="css/plugin.css" rel="stylesheet" type="text/css">
<script src="js/jquery-3.3.1.min.js"></script>
</head>

<body>
    <form id="form1" runat="server">
    
    <uc1:top ID="top1" runat="server" />
    <uc2:adv1 ID="adv1" runat="server" />


 <!-- list starts -->
    <section class="room-list">
        <div class="container" style="margin-top:-27px;">

<div class="text-right"><a href="/">首页</a> &gt;<a href="news__1.html">资讯中心</a><%#ShowNewsPath%></div>
<div class="smcmenu right_left">
    <ul>
    <asp:Repeater ID="Newsfl" runat="server">
    <ItemTemplate>
      <li><a href="news_<%#DataBinder.Eval(Container.DataItem, "ClassID")%>_1.html" class="<%# IsNbsp(DataBinder.Eval(Container.DataItem, "ClassID").ToString()) %>" title="<%#DataBinder.Eval(Container.DataItem, "ClassName")%>"><%#DataBinder.Eval(Container.DataItem, "ClassName")%></a></li>
    </ItemTemplate>
    </asp:Repeater>   
    </ul>
  </div><div class="blank20"></div>


            <div class="list-content">
                <div class="row">

  <asp:Repeater ID="rp_NewsList" runat="server">
      <ItemTemplate> 
                    <div class="col-md-4 col-sm-6 col-xs-6">
                        <div class="room-item">
                            <div class="">
                                <a href="news_detail-<%#Eval("NewsID") %>.html" title="<%#Eval("NewsTitle") %>"><img src="upimage/<%#Eval("PicPathSmall") %>" alt="<%#Eval("NewsTitle") %>" /></a>
                            </div>
                            <div class="room-content">
                                <div class="room-title" style="height:22px;">
                                    <h5 class="text-center"><a href="news_detail-<%#Eval("NewsID") %>.html" title="<%#Eval("NewsTitle") %>"><%#cutstr(Eval("NewsTitle").ToString(), 22)%></a></h5>  
                                </div>                                
                            </div>
                        </div>
                    </div>
        </ItemTemplate>
    </asp:Repeater>

                </div>
            </div>
            <div id="pages">
                <div class="page">
 <webdiyer:AspNetPager ID="AspNetPager1" runat="server" AlwaysShow="True" 
      FirstPageText="首页" InputBoxStyle="width:19px" LastPageText="尾页"
      meta:resourceKey="AspNetPager1" NextPageText="下一条" NumericButtonCount="5" OnPageChanged="AspNetPager1_PageChanged"
      PageSize="9" PrevPageText="上一条" Style="font-size: 14px"
      Width="100%" CustomInfoTextAlign="Left" UrlPaging="True" EnableUrlRewriting="True" 
                   UrlRewritePattern="news_%classid%_{0}.html" 
                        CurrentPageButtonStyle="style=color:#ffffff;">
</webdiyer:AspNetPager>  
                </div>
            </div>  


        </div>
    </section>
    <!-- list Ends -->



    <uc4:bottom ID="bottom1" runat="server" />
    
    </form>
</body>
</html>
