/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.advert.service;

import cn.com.mjsoft.cms.advert.bean.AdvertConfigBean;
import cn.com.mjsoft.cms.advert.bean.AdvertContentBean;
import cn.com.mjsoft.cms.advert.bean.AdvertPositionBean;
import cn.com.mjsoft.cms.advert.dao.AdvertDao;
import cn.com.mjsoft.cms.advert.dao.vo.AdvertConfig;
import cn.com.mjsoft.cms.advert.dao.vo.AdvertContent;
import cn.com.mjsoft.cms.advert.dao.vo.AdvertPosition;
import cn.com.mjsoft.cms.behavior.InitSiteGroupInfoBehavior;
import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.ServiceUtil;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.content.dao.ContentDao;
import cn.com.mjsoft.cms.metadata.bean.DataModelBean;
import cn.com.mjsoft.cms.metadata.bean.ModelFiledInfoBean;
import cn.com.mjsoft.cms.metadata.bean.ModelPersistenceMySqlCodeBean;
import cn.com.mjsoft.cms.metadata.service.MetaDataService;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.cache.Cache;
import cn.com.mjsoft.framework.cache.impl.LRUCache;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.util.DateAndTimeUtil;
import cn.com.mjsoft.framework.util.MathUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.log4j.Logger;

public class AdvertService {
    private static Logger _$7 = Logger.getLogger(AdvertService.class);
    private static final Map _$6 = new HashMap();
    private static final Map _$5 = new HashMap();
    private static MetaDataService _$4 = MetaDataService.getInstance();
    private static AdvertService _$3;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private AdvertDao _$2 = new AdvertDao(this.mysqlEngine);
    private ContentDao _$1 = new ContentDao(this.mysqlEngine);

    private AdvertService() {
    }

    private static synchronized void _$1() {
        if (null == _$3) {
            _$3 = new AdvertService();
        }
    }

    public static AdvertService getInstance() {
        if (null == _$3) {
            AdvertService._$1();
        }
        return _$3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewAdvertConfig(AdvertConfig advertConfig) {
        if (advertConfig == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            UpdateState updateState = this._$2.saveAdvertConfig(advertConfig);
            if (!updateState.haveKey()) {
                _$7.info((Object)("[AdvertService] addNewAdvertConfig : \u589e\u52a0config\u5931\u8d25, config:" + advertConfig));
                return;
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editAdvertCodeTemplate(AdvertConfig advertConfig) {
        if (advertConfig == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            this._$2.updateAdvertCodeTemplate(advertConfig.getAdvertCode(), advertConfig.getConfigId());
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editAdvertConfig(AdvertConfig advertConfig) {
        if (advertConfig == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            this._$2.updateAdvertConfig(advertConfig);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    public AdvertConfigBean retrieveSingleAdvertConfigBeanByConfigId(Long l) {
        return this._$2.querySingleAdvertConfigBeanByConfigId(l);
    }

    public AdvertPositionBean retrieveSingleAdvertPositionBeanByPosId(Long l) {
        return this._$2.querySingleAdvertPositionBeanByPosId(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map retrieveSingleAdvertPositionMapByPosId(Long l) {
        Map map = null;
        try {
            this.mysqlEngine.beginTransaction();
            AdvertConfigBean advertConfigBean = this._$2.querySingleAdvertConfigBeanByPosId(l);
            if (advertConfigBean == null) {
                Map map2 = null;
                return map2;
            }
            if (advertConfigBean.getPosModelId() == null || advertConfigBean.getPosModelId() < 1L) {
                map = this._$2.querySingleAdvertPositionInfoByPosId(l);
            } else {
                DataModelBean dataModelBean = _$4.retrieveSingleDataModelBeanById(advertConfigBean.getPosModelId());
                ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean = _$4.retrieveSingleModelPerMysqlCodeBean(advertConfigBean.getPosModelId());
                map = this._$2.querySingleAdvertPositionInfoByPosId(l, dataModelBean, modelPersistenceMySqlCodeBean, advertConfigBean.getSiteId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        return map;
    }

    public AdvertContentBean retrieveSingleAdvertContentBeanByAdvertId(Long l) {
        return this._$2.querySingleAdvertContentBeanByAdvertId(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map retrieveSingleAdvertContentInfoByAdvertId(Long l) {
        Map map = null;
        try {
            this.mysqlEngine.beginTransaction();
            Map map2 = this._$2.querySingleAdvertContentInfoByAdvertId(l);
            AdvertConfigBean advertConfigBean = this._$2.querySingleAdvertConfigBeanByPosId((Long)map2.get("posId"));
            if (advertConfigBean == null) {
                Map map3 = null;
                return map3;
            }
            if (advertConfigBean.getContentModelId() == null || advertConfigBean.getContentModelId() < 1L) {
                map = map2;
            } else {
                DataModelBean dataModelBean = _$4.retrieveSingleDataModelBeanById(advertConfigBean.getContentModelId());
                ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean = _$4.retrieveSingleModelPerMysqlCodeBean(advertConfigBean.getContentModelId());
                map = this._$2.querySingleAdvertContentInfoByAdvertId(l, dataModelBean, modelPersistenceMySqlCodeBean, advertConfigBean.getSiteId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        return map;
    }

    public AdvertContentBean retrieveSingleAdvertContentBeanByAdvertFlag(String string) {
        return this._$2.querySingleAdvertContentBeanByAdvertFlag(string);
    }

    public List retrieveAdvertConfigParamBeanList(Long l, Long l2, Integer n, Boolean bl) {
        List list = null;
        list = bl.booleanValue() ? (Constant.ADVERT.ADVERT_CONFIG_CON_TYPE.equals(n) ? this._$2.queryAdvertConfigParamAndValueBeanListByPosId(l, l2, n) : this._$2.queryAdvertConfigParamAndValueBeanList(l, l2, n)) : (Constant.ADVERT.ADVERT_CONFIG_CON_TYPE.equals(n) ? this._$2.queryAdvertConfigParamBeanListByPosId(l, n) : this._$2.queryAdvertConfigParamBeanList(l, n));
        return list;
    }

    public List retrieveAllAdvertConfigBeanList() {
        return this._$2.queryAllAdvertConfigBeanList();
    }

    public List retrieveAllAdvertPosBeanList() {
        return this._$2.queryAllAdvertPosBeanList();
    }

    public List retrieveAllAdvertPosInfoList(Long l) {
        return this._$2.queryAllAdvertPosInfoList(l);
    }

    public List retrieveAllAdvertContentBeanList() {
        return this._$2.queryAllAdvertContentBeanList();
    }

    public List retrieveAllAdvertContentInfoList(Long l) {
        return this._$2.queryAllAdvertContentInfoList(l);
    }

    public List retrieveAdvertContentBeanListByPosId(Long l) {
        return this._$2.queryAdvertContentBeanListByPosId(l);
    }

    public List retrieveAdvertContentInfoListByPosId(Long l, Long l2) {
        return this._$2.queryAdvertContentBeanListByPosId(l, l2);
    }

    public AdvertConfigBean retrieveSingleAdvertConnfigBeanByPosId(Long l) {
        return this._$2.querySingleAdvertConfigBeanByPosId(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAdvertConfigAllInfo(Long l) {
        try {
            this.mysqlEngine.beginTransaction();
            this._$2.deleteAdvertConfigByConfigId(l);
            this._$2.deleteAdvertPositionByConfigId(l);
            this._$2.deleteAdvertConfigParamByConfigId(l);
            this._$2.deleteAdvertConfigParamValueByConfigId(l);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewAdvertPositionAndExtendParamValue(AdvertPosition advertPosition, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, Map map) {
        if (advertPosition == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            UpdateState updateState = this._$2.saveAdvertPosition(advertPosition);
            if (updateState.haveKey()) {
                if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                    ModelFiledInfoBean modelFiledInfoBean = null;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < list.size(); ++i) {
                        modelFiledInfoBean = (ModelFiledInfoBean)list.get(i);
                        arrayList.add(ServiceUtil.disposeDataModelFiledFromWeb(modelFiledInfoBean, map, null, true));
                    }
                    arrayList.add(updateState.getKey());
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), arrayList.toArray());
                }
            } else {
                _$7.info((Object)("[AdvertService] addNewAdvertPositionAndExtendParamValue : \u589e\u52a0Position\u5931\u8d25, Position:" + advertPosition));
                return;
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewAdvertContentAndExtendParamValue(AdvertContent advertContent, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, DataModelBean dataModelBean2, List list2, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean2, Map map) {
        if (advertContent == null) {
            return;
        }
        try {
            Map map2;
            Map map3;
            String string;
            Object object;
            AdvertPositionBean advertPositionBean;
            this.mysqlEngine.beginTransaction();
            UpdateState updateState = this._$2.saveAdvert(advertContent);
            if (updateState.haveKey()) {
                Object object2;
                advertPositionBean = this._$2.querySingleAdvertPositionBeanByPosId(advertContent.getPosId());
                if (advertPositionBean == null) {
                    _$7.error((Object)("[AdvertService] addNewAdvertContentAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u7248\u4f4d\u4fe1\u606f\u4e22\u5931 posId:" + advertContent.getPosId()));
                    return;
                }
                if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                    object2 = null;
                    object = new ArrayList();
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = (ModelFiledInfoBean)list.get(i);
                        object.add(ServiceUtil.disposeDataModelFiledFromWeb((ModelFiledInfoBean)object2, map, null, true));
                    }
                    object.add(updateState.getKey());
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), object.toArray());
                }
                if ((object2 = this._$2.querySingleAdvertConfigBeanByConfigId(advertPositionBean.getConfigId())) == null) {
                    _$7.error((Object)("[AdvertService] addNewAdvertContentAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u914d\u7f6e\u4fe1\u606f\u4e22\u5931 configId:" + advertPositionBean.getConfigId()));
                    return;
                }
                object = this._$2.querySingleAdvertContentBeanByAdvertId(updateState.getKey());
                string = ((AdvertConfigBean)object2).getAdvertCode();
                map3 = null;
                if (dataModelBean2 != null && list2 != null && modelPersistenceMySqlCodeBean2 != null) {
                    map3 = this._$2.querySingleAdvertPositionInfoByPosId(advertPositionBean.getPosId(), dataModelBean2, modelPersistenceMySqlCodeBean2, advertPositionBean.getSiteId());
                }
                map2 = null;
                if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                    map2 = this._$2.querySingleAdvertContentInfoByAdvertId(advertContent.getAdvertId(), dataModelBean, modelPersistenceMySqlCodeBean, advertPositionBean.getSiteId());
                }
            } else {
                _$7.info((Object)("[AdvertService] addNewAdvertContentAndExtendParamValue : \u589e\u52a0advert\u5931\u8d25, advert:" + advertContent));
                return;
            }
            this._$2.updateAdvertCode(((AdvertContentBean)object).getAdvertId(), this._$1(string, advertPositionBean, (AdvertContentBean)object, map3, map2, list2, list));
            this._$1(advertContent);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editAdvertContentAndExtendParamValue(AdvertContent advertContent, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, DataModelBean dataModelBean2, List list2, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean2, Map map) {
        if (advertContent == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            this.mysqlEngine.beginTransaction();
            this._$2.updateAdvertContent(advertContent);
            AdvertPositionBean advertPositionBean = this._$2.querySingleAdvertPositionBeanByPosId(advertContent.getPosId());
            if (advertPositionBean == null) {
                _$7.error((Object)("[AdvertService] editAdvertContentAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u7248\u4f4d\u4fe1\u606f\u4e22\u5931 posId:" + advertContent.getPosId()));
                return;
            }
            if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                object3 = null;
                object2 = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    object3 = (ModelFiledInfoBean)list.get(i);
                    object2.add(ServiceUtil.disposeDataModelFiledFromWeb((ModelFiledInfoBean)object3, map, null, true));
                }
                object = this._$1.querySingleUserDefineContentOnlyModelDataResultNotDisposeInfo(modelPersistenceMySqlCodeBean, dataModelBean.getRelateTableName(), advertContent.getAdvertId());
                object2.add(advertContent.getAdvertId());
                if (object.isEmpty()) {
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), object2.toArray());
                } else {
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getUpdateSql(), object2.toArray());
                }
            }
            if ((object3 = this._$2.querySingleAdvertConfigBeanByConfigId(advertPositionBean.getConfigId())) == null) {
                _$7.error((Object)("[AdvertService] addNewAdvertContentAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u914d\u7f6e\u4fe1\u606f\u4e22\u5931 configId:" + advertPositionBean.getConfigId()));
                return;
            }
            object2 = this._$2.querySingleAdvertContentBeanByAdvertId(advertContent.getAdvertId());
            object = ((AdvertConfigBean)object3).getAdvertCode();
            Map map2 = null;
            if (dataModelBean2 != null && list2 != null && modelPersistenceMySqlCodeBean2 != null) {
                map2 = this._$2.querySingleAdvertPositionInfoByPosId(advertPositionBean.getPosId(), dataModelBean2, modelPersistenceMySqlCodeBean2, advertPositionBean.getSiteId());
            }
            Map map3 = null;
            if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                map3 = this._$2.querySingleAdvertContentInfoByAdvertId(advertContent.getAdvertId(), dataModelBean, modelPersistenceMySqlCodeBean, advertPositionBean.getSiteId());
            }
            this._$2.updateAdvertCode(((AdvertContentBean)object2).getAdvertId(), this._$1((String)object, advertPositionBean, (AdvertContentBean)object2, map2, map3, list2, list));
            this._$1(advertContent);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAdvertStatus(List list, Integer n) {
        try {
            this.mysqlEngine.beginTransaction();
            long l = -1L;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                this._$2.updateAdvertStatus(l, n);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editAdvertPositionAndExtendParamValue(AdvertPosition advertPosition, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, DataModelBean dataModelBean2, List list2, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean2, Map map) {
        if (advertPosition == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            this.mysqlEngine.beginTransaction();
            this._$2.updateAdvertPosition(advertPosition);
            if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                object3 = null;
                object2 = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    object3 = (ModelFiledInfoBean)list.get(i);
                    object2.add(ServiceUtil.disposeDataModelFiledFromWeb((ModelFiledInfoBean)object3, map, null, true));
                }
                object = this._$1.querySingleUserDefineContentOnlyModelDataResultNotDisposeInfo(modelPersistenceMySqlCodeBean, dataModelBean.getRelateTableName(), advertPosition.getPosId());
                object2.add(advertPosition.getPosId());
                if (object.isEmpty()) {
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), object2.toArray());
                } else {
                    this._$1.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getUpdateSql(), object2.toArray());
                }
            }
            if ((object3 = this._$2.querySingleAdvertConfigBeanByConfigId(advertPosition.getConfigId())) == null) {
                _$7.error((Object)("[AdvertService] editAdvertPositionAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u914d\u7f6e\u4fe1\u606f\u4e22\u5931 configId:" + advertPosition.getConfigId()));
                return;
            }
            object2 = ((AdvertConfigBean)object3).getAdvertCode();
            object = this._$2.querySingleAdvertPositionBeanByPosId(advertPosition.getPosId());
            if (object == null) {
                _$7.error((Object)("[AdvertService] editAdvertPositionAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u7248\u4f4d\u4fe1\u606f\u4e22\u5931 posId:" + advertPosition.getPosId()));
                return;
            }
            List list3 = this._$2.queryAdvertContentBeanListByPosId(advertPosition.getPosId());
            Map map2 = null;
            if (dataModelBean != null) {
                map2 = this._$2.querySingleAdvertPositionInfoByPosId(advertPosition.getPosId(), dataModelBean, modelPersistenceMySqlCodeBean, advertPosition.getSiteId());
            }
            Map map3 = null;
            this.mysqlEngine.startBatch();
            AdvertContentBean advertContentBean = null;
            for (int i = 0; i < list3.size(); ++i) {
                advertContentBean = (AdvertContentBean)list3.get(i);
                map3 = this._$2.querySingleAdvertContentInfoByAdvertId(advertContentBean.getAdvertId(), dataModelBean2, modelPersistenceMySqlCodeBean2, advertPosition.getSiteId());
                this._$2.updateAdvertCode(advertContentBean.getAdvertId(), this._$1((String)object2, (AdvertPositionBean)object, advertContentBean, map2, map3, list, list2));
            }
            this.mysqlEngine.executeBatch();
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAdvertPositionAndParamValue(Long l, SiteGroupBean siteGroupBean) {
        try {
            DataModelBean dataModelBean;
            this.mysqlEngine.beginTransaction();
            AdvertConfigBean advertConfigBean = this._$2.querySingleAdvertConfigBeanByPosId(l);
            if (advertConfigBean.getPosModelId() > 0L && (dataModelBean = _$4.retrieveSingleDataModelBeanById(advertConfigBean.getPosModelId())) != null) {
                _$4.deleteAndClearDefModelInfo(l, advertConfigBean.getPosModelId(), siteGroupBean.getSiteFlag());
            }
            this._$2.deleteAdvertPositionByPosId(l);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdvertContentBean retrieveSingleAdvertContentBeanByPosIdOrderByImportance(String string) {
        AdvertContentBean advertContentBean = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Cache cache = (Cache)_$5.get("queryAdvertContentBeanListByPosFlagAndDate");
        String string2 = "queryAdvertContentBeanListByPosFlagAndDate:" + string + DateAndTimeUtil.getFormatDate(timestamp.getTime(), "yyyy-MM-dd");
        try {
            AdvertPositionBean advertPositionBean;
            this.mysqlEngine.beginTransaction();
            List list = (List)cache.getEntry(string2);
            if (list == null) {
                list = this._$2.queryAdvertContentBeanListByPosFlagAndDate(string, timestamp);
                cache.putEntry(string2, list);
            }
            if ((advertPositionBean = this._$2.querySingleAdvertPositionBeanByPosFlag(string)).getPosId() < 0L) {
                _$7.error((Object)("[AdvertService] editAdvertPositionAndExtendParamValue : \u5e7f\u544a\u6240\u5c5e\u7248\u4f4d\u4fe1\u606f\u4e22\u5931 posFlag:" + string));
                AdvertContentBean advertContentBean2 = null;
                return advertContentBean2;
            }
            if (Constant.ADVERT.ADVERT_SHOW_RANDOM.equals(advertPositionBean.getShowMode())) {
                if (list.size() > 0) {
                    advertContentBean = (AdvertContentBean)list.get(RandomUtils.nextInt((int)list.size()));
                }
            } else if (Constant.ADVERT.ADVERT_SHOW_WEIGHT.equals(advertPositionBean.getShowMode())) {
                ArrayList<AdvertContentBean> arrayList = (ArrayList<AdvertContentBean>)_$6.get(string);
                if (arrayList != null) {
                    int n = RandomUtils.nextInt((int)arrayList.size());
                    advertContentBean = (AdvertContentBean)arrayList.get(n);
                } else {
                    int n;
                    AdvertContentBean advertContentBean3 = null;
                    arrayList = new ArrayList<AdvertContentBean>();
                    int n2 = 0;
                    for (n = 0; n < list.size(); ++n) {
                        advertContentBean3 = (AdvertContentBean)list.get(n);
                        n2 = advertContentBean3.getPercent();
                        for (int i = 0; i < n2; ++i) {
                            arrayList.add(advertContentBean3);
                        }
                    }
                    _$6.put(string, arrayList);
                    n = RandomUtils.nextInt((int)arrayList.size());
                    advertContentBean = (AdvertContentBean)arrayList.get(n);
                }
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        return advertContentBean;
    }

    private String _$1(String string, AdvertPositionBean advertPositionBean, AdvertContentBean advertContentBean, Map map, Map map2, List list, List list2) {
        String string2;
        int n;
        String string3 = string;
        string3 = StringUtil.replaceString(string, "${pos.width}", advertPositionBean.getWidth().toString(), false, false);
        string3 = StringUtil.replaceString(string3, "${pos.height}", advertPositionBean.getHeight().toString(), false, false);
        string3 = StringUtil.replaceString(string3, "${pos.flag}", advertPositionBean.getPosFlag(), false, false);
        string3 = StringUtil.replaceString(string3, "${ad.flag}", advertContentBean.getAdFlag(), false, false);
        string3 = StringUtil.replaceString(string3, "${ad.name}", advertContentBean.getAdName(), false, false);
        Integer n2 = advertContentBean.getTarget();
        String string4 = "_self";
        if (Constant.ADVERT.TARGET_BLANK.equals(n2)) {
            string4 = "_blank";
        }
        string3 = StringUtil.replaceString(string3, "${target}", string4, false, false);
        SiteGroupBean siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(advertPositionBean.getSiteId());
        string3 = StringUtil.replaceString(string3, "${basePath}", siteGroupBean.getSiteTemplateUrl(), false, false);
        ModelFiledInfoBean modelFiledInfoBean = null;
        String string5 = null;
        if (map != null) {
            for (n = 0; n < list.size(); ++n) {
                modelFiledInfoBean = (ModelFiledInfoBean)list.get(n);
                string2 = null;
                string2 = "${pos." + modelFiledInfoBean.getFieldSign() + "}";
                string5 = (String)map.get(modelFiledInfoBean.getFieldSign());
                if (string5 == null) {
                    string5 = "";
                }
                string3 = StringUtil.replaceString(string3, string2, string5.toString(), false, false);
            }
        }
        if (map2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                modelFiledInfoBean = (ModelFiledInfoBean)list2.get(n);
                string2 = null;
                string2 = "${ad." + modelFiledInfoBean.getFieldSign() + "}";
                string5 = (String)map2.get(modelFiledInfoBean.getFieldSign());
                if (string5 == null) {
                    string5 = "";
                }
                string3 = StringUtil.replaceString(string3, string2, string5.toString(), false, false);
            }
        }
        return string3;
    }

    private void _$1(AdvertContent advertContent) {
        List list = this._$2.queryAdvertContentBeanListByPosId(advertContent.getPosId());
        double d = 1.0;
        AdvertContentBean advertContentBean = null;
        for (int i = 0; i < list.size(); ++i) {
            d += ((AdvertContentBean)list.get(i)).getImportance().doubleValue();
        }
        Integer n = null;
        for (int i = 0; i < list.size(); ++i) {
            advertContentBean = (AdvertContentBean)list.get(i);
            n = Double.valueOf(MathUtil.div(advertContentBean.getImportance().doubleValue(), d, 2) * 100.0).intValue();
            this._$2.updateAdvertPercent(advertContentBean.getAdvertId(), n);
        }
    }

    public static void clearCache() {
        Cache cache = (Cache)_$5.get("queryAdvertContentBeanListByPosFlagAndDate");
        cache.clearAllEntry();
        AdvertDao.clearCache();
        _$6.clear();
    }

    public static void main(String[] stringArray) {
        double d = 2500.0;
        double d2 = 1940.0;
        double d3 = 520.0;
        double d4 = 40.0;
        System.out.println("101:" + Double.valueOf(MathUtil.div(d4, d, 2) * 100.0).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAdvertContent(List list, SiteGroupBean siteGroupBean) {
        try {
            this.mysqlEngine.beginTransaction();
            AdvertConfigBean advertConfigBean = null;
            DataModelBean dataModelBean = null;
            long l = -1L;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                advertConfigBean = this._$2.querySingleAdvertConfigBeanByAdId(l);
                if (advertConfigBean != null && (dataModelBean = _$4.retrieveSingleDataModelBeanById(advertConfigBean.getContentModelId())) != null) {
                    _$4.deleteAndClearDefModelInfo(l, advertConfigBean.getContentModelId(), siteGroupBean.getSiteFlag());
                }
                this._$2.deleteAdvertContentById(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            AdvertService.clearCache();
        }
    }

    public boolean checkExistAdConfigAllCms(Long l) {
        Long l2 = this._$2.querySingleAdvertPositionCountByCfgId(l);
        return l2 > 0L;
    }

    static {
        _$5.put("queryAdvertContentBeanListByPosFlagAndDate", new LRUCache(60));
        _$3 = null;
    }
}

