/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.block.service;

import cn.com.mjsoft.cms.block.bean.BlockInfoBean;
import cn.com.mjsoft.cms.block.bean.BlockTypeBean;
import cn.com.mjsoft.cms.block.dao.BlockDao;
import cn.com.mjsoft.cms.block.dao.vo.BlockInfo;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.schedule.dao.ScheduleDao;
import cn.com.mjsoft.cms.schedule.service.ScheduleService;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BlockService {
    private static Logger _$5 = Logger.getLogger(BlockService.class);
    private static BlockService _$4 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private ScheduleService _$3 = ScheduleService.getInstance();
    private BlockDao _$2 = new BlockDao(this.mysqlEngine);
    private ScheduleDao _$1 = new ScheduleDao(this.mysqlEngine);

    private BlockService() {
    }

    private static synchronized void _$1() {
        if (null == _$4) {
            _$4 = new BlockService();
        }
    }

    public static BlockService getInstance() {
        if (null == _$4) {
            BlockService._$1();
        }
        return _$4;
    }

    public List retrieveAllBlockBeanListByCurrSite() {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$2.queryAllBlockInfoBeanBySiteId(siteGroupBean.getSiteId());
    }

    public List retrieveBlockBeanListByTypeId(Long l) {
        return this._$2.queryBlockInfoBeanByTypeId(l);
    }

    public BlockInfoBean retrieveSingleBlockBean(Long l) {
        return this._$2.querySingleBlockBean(l);
    }

    public BlockInfoBean retrieveSingleBlockBean(String string) {
        return this._$2.querySingleBlockBean(string);
    }

    public List retrieveBlockBeanBySomeFlag(List list) {
        String string = null;
        BlockInfoBean blockInfoBean = null;
        ArrayList<BlockInfoBean> arrayList = new ArrayList<BlockInfoBean>();
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            blockInfoBean = this._$2.querySingleBlockBean(string);
            if (blockInfoBean == null) continue;
            arrayList.add(blockInfoBean);
        }
        return arrayList;
    }

    public void addNewBlockType(String string, String string2, String string3, String string4) {
        this._$2.saveBlockType(string, string2, string3, string4);
    }

    public void editBlockType(String string, String string2, Long l) {
        this._$2.updateBlockType(string, string2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewBlock(SiteGroupBean siteGroupBean, BlockInfo blockInfo) {
        try {
            this.mysqlEngine.beginTransaction();
            UpdateState updateState = this._$2.save(blockInfo);
            if (updateState.haveKey()) {
                blockInfo.setBlockId(updateState.getKey());
                if (blockInfo.getPeriod() > 0) {
                    this._$3.addNewPublishBlockJob(siteGroupBean, blockInfo);
                }
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            BlockDao.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editBlock(SiteGroupBean siteGroupBean, BlockInfo blockInfo) {
        try {
            this.mysqlEngine.beginTransaction();
            this._$2.updateBlockInfo(blockInfo);
            this._$3.stopPublishBlockScheduleJob(blockInfo.getBlockId());
            if (blockInfo.getJobId() != null && blockInfo.getJobId() > 0L) {
                if (blockInfo.getPeriod() == 0) {
                    this._$1.deleteScheduleJobDetailByJobId(blockInfo.getJobId());
                    this._$2.updateBlockJobId(blockInfo.getBlockId(), null);
                } else {
                    this._$3.updatePublishBlockJob(siteGroupBean, blockInfo);
                }
            } else if (blockInfo.getPeriod() != 0) {
                this._$3.addNewPublishBlockJob(siteGroupBean, blockInfo);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            BlockDao.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockInfoById(List list) {
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 1L) continue;
                BlockInfoBean blockInfoBean = this._$2.querySingleBlockBean(l);
                this._$2.deleteBlockInfoById(l);
                this._$1.deleteScheduleJobDetailByJobId(blockInfoBean.getJobId());
                this._$3.stopPublishBlockScheduleJob(blockInfoBean.getBlockId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            BlockDao.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockTypeById(List list) {
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            List list2 = null;
            BlockInfoBean blockInfoBean = null;
            for (int i = 0; i < list.size(); ++i) {
                l = list.get(i) instanceof String ? Long.valueOf(StringUtil.getLongValue((String)list.get(i), -1L)) : (Long)list.get(i);
                if (l < 1L) continue;
                list2 = this._$2.queryBlockInfoBeanByTypeId(l);
                for (int j = 0; j < list2.size(); ++j) {
                    blockInfoBean = (BlockInfoBean)list2.get(j);
                    this._$2.deleteBlockInfoById(blockInfoBean.getBlockId());
                    this._$1.deleteScheduleJobDetailByJobId(blockInfoBean.getJobId());
                    this._$3.stopPublishBlockScheduleJob(blockInfoBean.getBlockId());
                }
                this._$2.deleteBlockTypeById(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            BlockDao.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockPublishDateTrace(Long l, Timestamp timestamp) {
        try {
            this.mysqlEngine.beginTransaction();
            Map map = this._$2.queryBlockPublishDate(l);
            if (map.isEmpty()) {
                this._$2.saveBlockPublishDate(l, timestamp);
            } else {
                this._$2.updateBlockPublishDate(l, timestamp);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public void updateBlockPublishStaticUrl(Long l, String string) {
        this._$2.updateBlockPublishStaticUrl(l, string);
        BlockDao.clearCache();
    }

    public List retrieveAllBlockTypeBeanListByCurrSite() {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$2.queryAllBlockTypeBeanList(siteGroupBean.getSiteFlag());
    }

    public BlockTypeBean retrieveSingleBlockTypeBean(Long l) {
        return this._$2.querySingleBlockTypeBeanById(l);
    }

    public Object getBlockPubDateInfoTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        return this._$2.queryBlockPublishDate(l);
    }

    public void test() {
        this._$2.test();
    }

    public static void main(String[] stringArray) {
        BlockService.getInstance().test();
    }
}

