/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.questionnaire.service;

import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.ServiceUtil;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.questionnaire.bean.SurveyBaseInfoBean;
import cn.com.mjsoft.cms.questionnaire.bean.SurveyGroupBean;
import cn.com.mjsoft.cms.questionnaire.bean.SurveyOptionInfoBean;
import cn.com.mjsoft.cms.questionnaire.dao.SurveyDao;
import cn.com.mjsoft.cms.questionnaire.dao.vo.SurveyBaseInfo;
import cn.com.mjsoft.cms.questionnaire.dao.vo.SurveyGroup;
import cn.com.mjsoft.cms.questionnaire.dao.vo.SurveyOptionInfo;
import cn.com.mjsoft.cms.questionnaire.dao.vo.SurveyVoteInfo;
import cn.com.mjsoft.cms.resources.service.ResourcesService;
import cn.com.mjsoft.cms.schedule.service.ScheduleService;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.Auth;
import cn.com.mjsoft.framework.security.headstream.IUser;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.DateAndTimeUtil;
import cn.com.mjsoft.framework.util.MathUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import cn.com.mjsoft.framework.web.ServletFlowContext;
import cn.com.mjsoft.framework.web.WebFlowContext;
import cn.com.mjsoft.framework.web.wing.CookieMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SurveyService {
    private static Logger _$7 = Logger.getLogger(SurveyService.class);
    private static final int _$6 = 630720000;
    private ScheduleService _$5 = ScheduleService.getInstance();
    private ResourcesService _$4 = ResourcesService.getInstance();
    public static final List voteDelayList = new ArrayList();
    private static final int _$3 = 5;
    private static SurveyService _$2 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private SurveyDao _$1 = new SurveyDao(this.mysqlEngine);

    private SurveyService() {
    }

    private static synchronized void _$1() {
        if (null == _$2) {
            _$2 = new SurveyService();
        }
    }

    public static SurveyService getInstance() {
        if (null == _$2) {
            SurveyService._$1();
        }
        return _$2;
    }

    public void addNewSurveyGroup(SurveyGroup surveyGroup) {
        this._$1.saveSurveyGroup(surveyGroup);
        SurveyDao.clearCache();
    }

    public Long retrieveAllSurveyGroupBeanCount(Long l) {
        return this._$1.queryAllQuestBaseInfoBeanCount(l);
    }

    public List retrieveAllSurveyGroupBeanList(Long l, Long l2, Integer n) {
        return this._$1.queryAllQuestBaseInfoBeanList(l, l2, n);
    }

    public SurveyGroupBean retrieveSingleSurveyGroupBeanByQuestId(Long l) {
        return this._$1.querySingleQuestBaseInfoBeanByQuestId(l);
    }

    public SurveyGroupBean retrieveSingleQuestBaseInfoBeanByQuestFlag(String string) {
        return this._$1.querySingleQuestBaseInfoBeanByQuestFlag(string);
    }

    public void editSurveyGroup(SurveyGroup surveyGroup) {
        this._$1.updateSurveyGroup(surveyGroup);
        SurveyDao.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSurveyAndOption(SurveyBaseInfo surveyBaseInfo, List list) {
        if (surveyBaseInfo == null || list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Integer n = this._$1.queryMaxSurveyOrderFlag(surveyBaseInfo.getGroupId());
            if (n != null) {
                surveyBaseInfo.setOrderFlag(n + 1);
            }
            UpdateState updateState = this._$1.saveSurveyBaseInfo(surveyBaseInfo);
            Long l = null;
            if (updateState.haveKey()) {
                l = updateState.getKey();
                SurveyOptionInfo surveyOptionInfo = null;
                for (int i = 0; i < list.size(); ++i) {
                    surveyOptionInfo = (SurveyOptionInfo)list.get(i);
                    surveyOptionInfo.setSurveyId(l);
                    this._$1.saveSurveyOptionInfo(surveyOptionInfo);
                }
            } else {
                _$7.info((Object)("[SurveyService] addNewSurveyAndOption : \u589e\u52a0survey\u5931\u8d25,survey:" + surveyBaseInfo));
                return;
            }
            this._$1(l);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            SurveyDao.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editSurveyAndOption(SurveyBaseInfo surveyBaseInfo, List list) {
        if (surveyBaseInfo == null || list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            SurveyBaseInfoBean surveyBaseInfoBean = this._$1.querySingleSurveyBaseInfoBeanBySurveyId(surveyBaseInfo.getSurveyId());
            if (surveyBaseInfoBean == null) {
                return;
            }
            this._$1.updateSurveyBaseInfo(surveyBaseInfo);
            this._$1.deletesSurveyOptionBySurveyId(surveyBaseInfo.getSurveyId());
            SurveyOptionInfo surveyOptionInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                surveyOptionInfo = (SurveyOptionInfo)list.get(i);
                surveyOptionInfo.setSurveyId(surveyBaseInfo.getSurveyId());
                this._$1.saveSurveyOptionInfo(surveyOptionInfo);
            }
            this._$1(surveyBaseInfoBean.getSurveyId());
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            SurveyDao.clearCache();
        }
    }

    public List retrieveSurveyBaseInfoBeanListByGroupId(Long l) {
        return this._$1.querySurveyBaseInfoBeanListByGroupId(l);
    }

    public List retrieveSurveyBaseInfoBeanListByGroupFlag(String string) {
        return this._$1.querySurveyBaseInfoBeanListByGroupFlag(string);
    }

    public SurveyBaseInfoBean retrieveSingleSurveyBaseInfoBeanBySurveyId(Long l) {
        return this._$1.querySingleSurveyBaseInfoBeanBySurveyId(l);
    }

    public List retrieveSurveyOptionBeanListBySurveyId(Long l) {
        return this._$1.querySurveyOptionBeanListBySurveyId(l);
    }

    public Long retrieveSurveyVoteInfoCountBySurveyId(Long l) {
        return this._$1.querySurveyVoteInfoCountBySurveyId(l);
    }

    public List retrieveSurveyVoteInfoBySurveyId(Long l, Long l2, Integer n) {
        return this._$1.querySurveyVoteInfoBySurveyId(l, l2, n);
    }

    public void addNewClientUserVoteInfo(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            voteDelayList.add(list.get(i));
        }
        if (voteDelayList.size() >= 5) {
            this._$5.startCollectUserVoteInfoJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferUserVoteInfoCacheToPe() {
        ArrayList arrayList = null;
        Object object = voteDelayList;
        synchronized (object) {
            arrayList = new ArrayList(voteDelayList);
            voteDelayList.clear();
            _$7.info((Object)("[SurveyService] transferUserVoteInfoCacheToPe : DelayList-isEmpty:" + voteDelayList.isEmpty()));
        }
        _$7.info((Object)("[StatService] transferVisitorStatInfoCacheToPe : DelayList " + voteDelayList));
        object = new HashMap();
        Integer n = null;
        Long l = null;
        try {
            this.mysqlEngine.beginTransaction();
            this.mysqlEngine.startBatch();
            SurveyVoteInfo surveyVoteInfo = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                surveyVoteInfo = (SurveyVoteInfo)arrayList.get(i);
                l = surveyVoteInfo.getOptId();
                if (l > 0L && StringUtil.isStringNull(surveyVoteInfo.getVoteText())) {
                    n = (Integer)object.get(l);
                    if (n == null) {
                        object.put(l, 1);
                        continue;
                    }
                    object.put(l, n + 1);
                    continue;
                }
                surveyVoteInfo.setVoteText(ServiceUtil.cleanBasicHtmlByWhiteRule(surveyVoteInfo.getVoteText()));
                this._$1.saveVoteInfo(surveyVoteInfo);
            }
            Iterator iterator = object.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                this._$1.updateVoteCount((Long)entry.getKey(), (Integer)entry.getValue());
            }
            this.mysqlEngine.executeBatch();
            if (surveyVoteInfo != null) {
                this._$1(surveyVoteInfo.getSurveyId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        SurveyDao.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapSurveyOrder(Long l, String string, String string2) {
        try {
            SurveyBaseInfoBean surveyBaseInfoBean;
            this.mysqlEngine.beginTransaction();
            SurveyBaseInfoBean surveyBaseInfoBean2 = this._$1.querySingleSurveyBaseInfoBeanBySurveyId(l);
            if (surveyBaseInfoBean2 == null) {
                return;
            }
            if ("up".equals(string)) {
                SurveyBaseInfoBean surveyBaseInfoBean3 = this._$1.queryFirstLessOrderFlagBySurveyId(l, string2);
                if (surveyBaseInfoBean3 != null) {
                    Integer n = surveyBaseInfoBean2.getOrderFlag();
                    this._$1.updateSurveyOrderFlag(l, surveyBaseInfoBean3.getOrderFlag());
                    this._$1.updateSurveyOrderFlag(surveyBaseInfoBean3.getSurveyId(), n);
                }
            } else if ("down".equals(string) && (surveyBaseInfoBean = this._$1.queryFirstBigOrderFlagBySurveyId(l, string2)) != null) {
                Integer n = surveyBaseInfoBean2.getOrderFlag();
                this._$1.updateSurveyOrderFlag(l, surveyBaseInfoBean.getOrderFlag());
                this._$1.updateSurveyOrderFlag(surveyBaseInfoBean.getSurveyId(), n);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            SurveyDao.clearCache();
        }
    }

    public Long retrieveSurveyGroupBeanCountByClassId(String string, Long l) {
        return this._$1.querySurveyGroupBeanCountByClassId(string, l);
    }

    public List retrieveSurveyGroupBeanListByClassId(Long l, String string, Long l2, Integer n) {
        return this._$1.querySurveyGroupBeanListByClassId(l, string, l2, n);
    }

    public int judgeUserCaptcha(String string, ServletFlowContext servletFlowContext, Map map) {
        SurveyGroupBean surveyGroupBean = this._$1.querySingleQuestBaseInfoBeanByQuestFlag(string);
        if (surveyGroupBean.getGroupId() < 0L) {
            return -2;
        }
        Integer n = surveyGroupBean.getNeedCaptcha();
        if (n != 0) {
            if (n == 1) {
                return ServiceUtil.checkCode(servletFlowContext, (String)map.get("jtopcms-vote-captcha-" + string));
            }
            if (n == 2) {
                Auth auth = SecuritySessionKeeper.getSecuritySession().getAuth();
                IUser iUser = (IUser)SecuritySessionKeeper.getSecuritySession().getMember();
                boolean bl = false;
                if (auth == null || !auth.isAuthenticated() || iUser == null) {
                    bl = true;
                }
                if (bl) {
                    return ServiceUtil.checkCode(servletFlowContext, (String)map.get("jtopcms-vote-captcha-" + string));
                }
            }
        }
        return 1;
    }

    public boolean judgeUserVote(String string, String string2, WebFlowContext webFlowContext) {
        SurveyGroupBean surveyGroupBean = this._$1.querySingleQuestBaseInfoBeanByQuestFlag(string);
        if (surveyGroupBean.getGroupId() < 0L) {
            return false;
        }
        String string3 = DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd HH:mm:ss");
        CookieMap cookieMap = webFlowContext.getCookie("JTOPCMS-VOTE-INFO");
        String string4 = null;
        if (Constant.SURVEY.RESTR_COOKIE_MODE.equals(surveyGroupBean.getRestriction())) {
            if (cookieMap == null) {
                webFlowContext.addCookie("JTOPCMS-VOTE-INFO", string + "=" + DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd HH:mm:ss") + ",", 630720000);
            } else {
                string4 = (String)cookieMap.get("JTOPCMS-VOTE-INFO");
                String string5 = null;
                if (string4.indexOf(string + "=") != -1) {
                    int n = string4.indexOf(string + "=");
                    string5 = StringUtil.subString(string4, n, string4.indexOf(",", n));
                    String[] stringArray = StringUtil.split(string5, "=");
                    int n2 = DateAndTimeUtil.getHourInterval(string3, stringArray[1], "yyyy-MM-dd HH:mm:ss");
                    if (n2 < surveyGroupBean.getRestInterval()) {
                        return false;
                    }
                    String string6 = StringUtil.replaceString(string4, string5, string + "=" + string3, false, false);
                    cookieMap.put(Integer.valueOf(630720000).toString(), string6);
                } else {
                    String string7 = string + "=" + DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd HH:mm:ss") + ",";
                    webFlowContext.addCookie("JTOPCMS-VOTE-INFO", string4 + string7, 630720000);
                }
            }
        } else if (Constant.SURVEY.RESTR_IP_MODE.equals(surveyGroupBean.getRestriction())) {
            String string8 = this._$1.queryIpVoteTraceDateTime(string2, surveyGroupBean.getGroupId());
            if (string8 == null) {
                this._$1.saveIpVoteTrace(string2, surveyGroupBean.getGroupId(), string3);
            } else {
                int n = DateAndTimeUtil.getHourInterval(string3, string8, "yyyy-MM-dd HH:mm:ss");
                if (n < surveyGroupBean.getRestInterval()) {
                    return false;
                }
                this._$1.updateIpVoteTrace(string2, surveyGroupBean.getGroupId(), string3);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSurveyGroupInfo(List list) {
        if (list == null) {
            return;
        }
        Long l = null;
        List list2 = null;
        SurveyBaseInfoBean surveyBaseInfoBean = null;
        try {
            this.mysqlEngine.beginTransaction();
            List list3 = null;
            SurveyOptionInfoBean surveyOptionInfoBean = null;
            for (int i = 0; i < list.size(); ++i) {
                l = list.get(i) instanceof String ? Long.valueOf(StringUtil.getLongValue((String)list.get(i), -1L)) : (Long)list.get(i);
                if (l < 0L) continue;
                this._$1.deleteSurveyGroupByGroupId(l);
                list2 = this._$1.querySurveyBaseInfoBeanListByGroupId(l);
                for (int j = 0; j < list2.size(); ++j) {
                    surveyBaseInfoBean = (SurveyBaseInfoBean)list2.get(j);
                    list3 = this._$1.querySurveyOptionBeanListBySurveyIdNoCache(surveyBaseInfoBean.getSurveyId());
                    for (int k = 0; k < list3.size(); ++k) {
                        surveyOptionInfoBean = (SurveyOptionInfoBean)list3.get(k);
                        ServiceUtil.deleteSiteResTraceMode(StringUtil.getLongValue(surveyOptionInfoBean.getOptionImageResId(), -1L));
                    }
                    this._$1.deletesSurveyOptionBySurveyId(surveyBaseInfoBean.getSurveyId());
                    this._$1.deletesSurveyBaseInfoBySurveyId(surveyBaseInfoBean.getSurveyId());
                    this._$1.deleteSurveyVoteInfoBySurveyId(surveyBaseInfoBean.getSurveyId());
                }
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSurveyInfo(List list) {
        Long l = null;
        try {
            this.mysqlEngine.beginTransaction();
            List list2 = null;
            SurveyOptionInfoBean surveyOptionInfoBean = null;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                list2 = this._$1.querySurveyOptionBeanListBySurveyId(l);
                for (int j = 0; j < list2.size(); ++j) {
                    surveyOptionInfoBean = (SurveyOptionInfoBean)list2.get(j);
                    this._$4.updateSiteResourceTraceUseStatus(StringUtil.getLongValue(surveyOptionInfoBean.getOptionImageResId(), -1L), Constant.COMMON.OFF);
                }
                this._$1.deletesSurveyOptionBySurveyId(l);
                this._$1.deletesSurveyBaseInfoBySurveyId(l);
                this._$1.deleteSurveyVoteInfoBySurveyId(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    private void _$1(Long l) {
        int n;
        List list = this._$1.querySurveyOptionBeanListBySurveyIdNoCache(l);
        if (list == null) {
            return;
        }
        SurveyOptionInfoBean surveyOptionInfoBean = null;
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            surveyOptionInfoBean = (SurveyOptionInfoBean)list.get(n);
            n2 += surveyOptionInfoBean.getVote().intValue();
        }
        if (n2 > 0) {
            for (n = 0; n < list.size(); ++n) {
                surveyOptionInfoBean = (SurveyOptionInfoBean)list.get(n);
                surveyOptionInfoBean.setVotePer(Double.valueOf(MathUtil.mul(MathUtil.div(surveyOptionInfoBean.getVote().intValue(), n2, 3), 100.0)).intValue());
                this._$1.updateVotePercent(surveyOptionInfoBean.getOptionId(), Double.valueOf(MathUtil.mul(MathUtil.div(surveyOptionInfoBean.getVote().intValue(), n2, 3), 100.0)).intValue());
            }
        }
    }
}

