/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.search.service;

import cn.com.mjsoft.cms.behavior.InitSiteGroupInfoBehavior;
import cn.com.mjsoft.cms.channel.bean.ContentClassBean;
import cn.com.mjsoft.cms.channel.service.ChannelService;
import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.common.page.Page;
import cn.com.mjsoft.cms.content.bean.ContentMainInfoBean;
import cn.com.mjsoft.cms.content.service.ContentService;
import cn.com.mjsoft.cms.metadata.bean.ModelFiledInfoBean;
import cn.com.mjsoft.cms.metadata.service.MetaDataService;
import cn.com.mjsoft.cms.publish.bean.PublishRuleBean;
import cn.com.mjsoft.cms.publish.bean.PublishStatusBean;
import cn.com.mjsoft.cms.publish.service.PublishService;
import cn.com.mjsoft.cms.search.bean.SearchIndexContentStateBean;
import cn.com.mjsoft.cms.search.dao.SearchDao;
import cn.com.mjsoft.cms.search.dao.vo.SearchIndexContentState;
import cn.com.mjsoft.cms.search.html.ClientSearchContentListTag;
import cn.com.mjsoft.cms.search.service.lIIIIlIllIIlIIlI;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.cache.jsr14.ReadWriteLockHashMap;
import cn.com.mjsoft.framework.config.SystemRuntimeConfig;
import cn.com.mjsoft.framework.config.impl.SystemConfiguration;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.LuceneUtil;
import cn.com.mjsoft.framework.util.MathUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.jsoup.Jsoup;

public class SearchService {
    private static final Logger _$14 = Logger.getLogger(SearchService.class);
    private static final Integer _$13 = 500;
    private Map _$12 = new ReadWriteLockHashMap();
    private Map _$11 = new ReadWriteLockHashMap();
    private Map _$10 = new HashMap();
    private static Double _$9 = 32.0;
    private static Integer _$8 = 20;
    private static Integer _$7 = 500;
    public static DecimalFormat df2 = new DecimalFormat("##0.000");
    private static SearchService _$6 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private static ChannelService _$5 = ChannelService.getInstance();
    private static ContentService _$4 = ContentService.getInstance();
    private static MetaDataService _$3 = MetaDataService.getInstance();
    private static PublishService _$2 = PublishService.getInstance();
    private SearchDao _$1 = new SearchDao(this.mysqlEngine);

    private SearchService() {
    }

    private static synchronized void _$1() {
        if (null == _$6) {
            _$6 = new SearchService();
        }
    }

    public static SearchService getInstance() {
        if (null == _$6) {
            SearchService._$1();
        }
        return _$6;
    }

    public UpdateState addIndexContentState(SearchIndexContentState searchIndexContentState) {
        return this._$1.saveIndexContentState(searchIndexContentState);
    }

    public List retrieveIndexContentStateByFlag(Long l, Long l2, Integer n) {
        return this._$1.queryIndexContentStateByFlag(l, l2, n);
    }

    public void deleteIndexContentStateByLastId(Long l, Long l2, Long l3) {
        this._$1.deleteIndexContentStateByLastId(l, l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeSearchQueryKeyCount(SiteGroupBean siteGroupBean) {
        Map map = (Map)ClientSearchContentListTag.searchKeyMap.get(siteGroupBean.getSiteId());
        try {
            this.mysqlEngine.beginTransaction();
            Map.Entry entry2 = null;
            String string = null;
            Integer n = null;
            if (map != null) {
                for (Map.Entry entry2 : map.entrySet()) {
                    string = StringUtil.filterHTMLNotApos((String)entry2.getKey());
                    n = (Integer)entry2.getValue();
                    if (this._$1.querySearchKeyCount(string) > 0L) {
                        this._$1.updateSearchKeyCount(string, n);
                        continue;
                    }
                    this._$1.saveNewSearchKeyCount(string, n, siteGroupBean.getSiteId());
                }
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        if (map != null) {
            map.clear();
        }
    }

    public List disposeTextKeyword(String string) {
        if (StringUtil.isStringNull(string)) {
            return new ArrayList();
        }
        List list = LuceneUtil.wordAnalysis(string, " ", true);
        String string2 = null;
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Integer n = null;
        for (int i = 0; i < list.size(); ++i) {
            string2 = (String)list.get(i);
            if (string2.length() < 2 || StringUtil.getDoubleValue(string2, -9999999.999999) != -9999999.999999) continue;
            n = (Integer)treeMap.get(string2);
            if (n == null) {
                treeMap.put(string2, 1);
                continue;
            }
            treeMap.put(string2, n + 1);
        }
        ArrayList arrayList = new ArrayList(treeMap.entrySet());
        Collections.sort(arrayList, new lIIIIlIllIIlIIlI(this));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Map.Entry entry = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            entry = arrayList.get(i);
            if ((Integer)entry.getValue() <= 1) continue;
            arrayList2.add(entry.getKey());
        }
        String string3 = null;
        Integer n2 = null;
        for (int i = 0; i < list.size(); ++i) {
            string3 = (String)list.get(i);
            n2 = (Integer)treeMap.get(string3);
            if (n2 == null || n2 > 1) continue;
            arrayList2.add(string3);
        }
        return arrayList2;
    }

    public void regIndexSearcher(String string, String string2) {
    }

    public IndexWriter getIndexWriter(String string, String string2) {
        IndexWriter indexWriter = LuceneUtil.createWriter(string2, (double)_$9, (int)_$8, (int)_$7);
        return indexWriter;
    }

    public IndexWriter getIndexWriter(String string, Directory directory) {
        IndexWriter indexWriter = LuceneUtil.createWriter(directory, (double)_$9, (int)_$8, (int)_$7);
        return indexWriter;
    }

    public void commit(IndexWriter indexWriter) {
        LuceneUtil.commit(indexWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSearcher getIndexSearcher(String string, String string2) {
        IndexSearcher indexSearcher = null;
        Map map = this._$12;
        synchronized (map) {
            indexSearcher = (IndexSearcher)this._$12.get(string);
            if (indexSearcher == null) {
                indexSearcher = LuceneUtil.createSearcher(LuceneUtil.createReader(string2));
                this._$12.put(string, indexSearcher);
            }
            return indexSearcher;
        }
    }

    public void cleanOutdatedReaderMap(String string) {
        IndexSearcher indexSearcher = (IndexSearcher)this._$10.get(string);
        if (indexSearcher == null) {
            _$14.info((Object)"[SearchService] cleanOutdatedReaderMap \uff1a no old data!");
            return;
        }
        IndexReader indexReader = indexSearcher.getIndexReader();
        try {
            if (indexReader != null) {
                indexReader.close();
                _$14.info((Object)"[SearchService] cleanOutdatedReaderMap : close oldReader");
            }
            if (indexSearcher != null) {
                indexSearcher.close();
                _$14.info((Object)"[SearchService] cleanOutdatedReaderMap : close oldSearcher");
            }
            this._$10.remove(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSearchIndexMetadataByClassId(List list) {
        if (list == null) {
            return;
        }
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        String string = SearchService.getIndexRootFullPathAndCheckDir(siteGroupBean);
        String string2 = SearchService.buildKey(string, siteGroupBean.getSiteId());
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.getIndexWriter(string2, string);
            long l = -1L;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l <= 0L) continue;
                LuceneUtil.deleteIndexDocument(indexWriter, new Term("classId", Long.valueOf(l).toString()));
            }
        }
        catch (Throwable throwable) {
            LuceneUtil.close(indexWriter);
            throw throwable;
        }
        LuceneUtil.close(indexWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSearchIndexMetadataBySite(SiteGroupBean siteGroupBean) {
        if (siteGroupBean == null) {
            return;
        }
        String string = SearchService.getIndexRootFullPathAndCheckDir(siteGroupBean);
        String string2 = SearchService.buildKey(string, siteGroupBean.getSiteId());
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.getIndexWriter(string2, string);
            LuceneUtil.deleteIndexDocument(indexWriter, new Term("siteId", siteGroupBean.getSiteId().toString()));
        }
        catch (Throwable throwable) {
            LuceneUtil.close(indexWriter);
            throw throwable;
        }
        LuceneUtil.close(indexWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferContentStateListAndAddToIndex(IndexWriter indexWriter, List list) {
        if (list == null) {
            return;
        }
        try {
            SearchIndexContentStateBean searchIndexContentStateBean = null;
            for (int i = 0; i < list.size(); ++i) {
                searchIndexContentStateBean = (SearchIndexContentStateBean)list.get(i);
                if (Constant.JOB.SEARCH_INDEX_ADD.equals(searchIndexContentStateBean.getEventFlag()) || Constant.JOB.SEARCH_INDEX_EDIT.equals(searchIndexContentStateBean.getEventFlag())) {
                    LuceneUtil.addOrUpdateIndexDocument(indexWriter, SearchService.transferBeanToIndexDocument(searchIndexContentStateBean), searchIndexContentStateBean.getContentId().toString());
                    continue;
                }
                if (!Constant.JOB.SEARCH_INDEX_DEL.equals(searchIndexContentStateBean.getEventFlag())) continue;
                LuceneUtil.deleteIndexDocument(indexWriter, new Term("contentId", searchIndexContentStateBean.getContentId().toString()));
            }
        }
        finally {
            LuceneUtil.close(indexWriter);
        }
    }

    public static Object[] search(IndexSearcher indexSearcher, String string, String[] stringArray, String[] stringArray2, Long[] longArray, Long l, String[] stringArray3, Integer n, int n2) {
        if (StringUtil.isStringNull(string)) {
            return null;
        }
        int n3 = 0;
        TopDocs topDocs = null;
        BooleanQuery booleanQuery = new BooleanQuery();
        long l2 = 0L;
        double d = 0.0;
        try {
            int n4;
            long l3 = System.nanoTime();
            List list = LuceneUtil.wordAnalysis(string, " ", true);
            String string2 = null;
            for (n4 = 0; n4 < list.size(); ++n4) {
                string2 = (String)list.get(n4);
                BooleanQuery booleanQuery2 = new BooleanQuery();
                for (int i = 0; i < stringArray.length; ++i) {
                    booleanQuery2.add((Query)new TermQuery(new Term(stringArray[i], string2)), BooleanClause.Occur.SHOULD);
                }
                booleanQuery.add((Query)booleanQuery2, BooleanClause.Occur.MUST);
            }
            booleanQuery.add((Query)new TermQuery(new Term("censor", Constant.WORKFLOW.CENSOR_STATUS_SUCCESS.toString())), BooleanClause.Occur.MUST);
            if (stringArray3 != null) {
                for (n4 = 0; n4 < stringArray3.length; ++n4) {
                    booleanQuery.add((Query)new TermQuery(new Term("modelId", stringArray3[n4].toString())), BooleanClause.Occur.MUST);
                }
            }
            if (stringArray2 != null) {
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    booleanQuery.add((Query)new TermQuery(new Term("classId", stringArray2[n4].toString())), BooleanClause.Occur.MUST);
                }
            }
            if (longArray != null) {
                for (n4 = 0; n4 < longArray.length; ++n4) {
                    booleanQuery.add((Query)new TermQuery(new Term("classId", longArray[n4].toString())), BooleanClause.Occur.MUST_NOT);
                }
            }
            if (l != null && l > 0L) {
                booleanQuery.add((Query)new TermQuery(new Term("contentId", l.toString())), BooleanClause.Occur.MUST_NOT);
            }
            _$14.info((Object)("[query]" + booleanQuery.toString()));
            if (n < 1) {
                topDocs = indexSearcher.search((Query)booleanQuery, n2);
                n3 = topDocs.totalHits;
            } else {
                TopDocs topDocs2 = indexSearcher.search((Query)booleanQuery, n + 1);
                n3 = topDocs2.totalHits;
                if (n3 > 1) {
                    topDocs = indexSearcher.searchAfter(topDocs2.scoreDocs[n], (Query)booleanQuery, n2);
                }
            }
            l2 = System.nanoTime() - l3;
            d = MathUtil.div(l2, 1000000.0, 0);
            _$14.info((Object)("\u67e5\u8be2\u65f6\u95f4: " + d + " \u6beb\u79d2"));
            _$14.info((Object)("\u547d\u4e2d\u6570\uff1a" + n3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$14.error((Object)exception);
        }
        return new Object[]{topDocs, booleanQuery, df2.format(d / 1000.0), n3};
    }

    public Map getSearchMap() {
        return this._$12;
    }

    public Map getSearchOutdatedReaderMap() {
        return this._$10;
    }

    public static String buildKey(String string, Long l) {
        return "siteId:" + l + "rootPath:" + string;
    }

    public static String getIndexRootFullPathAndCheckDir(SiteGroupBean siteGroupBean) {
        SystemRuntimeConfig systemRuntimeConfig = SystemConfiguration.getInstance().getSystemConfig();
        String string = systemRuntimeConfig.getSystemRealPath() + File.separator + siteGroupBean.getSiteRoot() + File.separator + ".systemIndex";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public String retrieveSearchContentUrlLinkByContentId(Long l) {
        ContentMainInfoBean contentMainInfoBean = _$4.retrieveSingleContentMainInfoBean(l);
        if (contentMainInfoBean == null) {
            return null;
        }
        ContentClassBean contentClassBean = _$5.retrieveSingleClassBeanInfoByClassId(contentMainInfoBean.getClassId());
        if (contentClassBean == null || contentClassBean.getClassId() < 0L) {
            return null;
        }
        SiteGroupBean siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupFlagInfoCache.getEntry(contentClassBean.getSiteFlag());
        if (siteGroupBean == null) {
            return null;
        }
        if (Constant.SITE_CHANNEL.PAGE_PRODUCE_H_TYPE.equals(contentClassBean.getContentProduceType())) {
            String string = contentMainInfoBean.getStaticPageUrl();
            if (StringUtil.isStringNotNull(string)) {
                return siteGroupBean.getSiteUrl() + string;
            }
            PublishRuleBean publishRuleBean = _$2.retrieveSinglePublishRuleBean(contentClassBean.getContentPublishRuleId());
            if (publishRuleBean == null) {
                return siteGroupBean.getSiteUrl() + "NO_RULE";
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
            hashMap.put("contentId", l);
            String[] stringArray = publishRuleBean.getFullContentClassPublishPath(siteGroupBean, contentClassBean, hashMap, null);
            return siteGroupBean.getSiteUrl() + stringArray[1];
        }
        if (Constant.SITE_CHANNEL.PAGE_PRODUCE_D_TYPE.equals(contentClassBean.getContentProduceType())) {
            return this._$1(contentMainInfoBean, siteGroupBean, contentClassBean);
        }
        return null;
    }

    private String _$1(ContentMainInfoBean contentMainInfoBean, SiteGroupBean siteGroupBean, ContentClassBean contentClassBean) {
        String string = contentMainInfoBean.getEspecialTemplateUrl();
        if (StringUtil.isStringNull(string)) {
            string = contentClassBean.getContentTemplateUrl();
        }
        return siteGroupBean.getSiteUrl() + StringUtil.replaceString(string, "{content-id}", contentMainInfoBean.getContentId().toString(), false, false);
    }

    public static Document transferBeanToIndexDocument(SearchIndexContentStateBean searchIndexContentStateBean) {
        if (searchIndexContentStateBean == null) {
            return null;
        }
        Map map = _$4.retrieveSingleUserDefineContent(searchIndexContentStateBean.getModelId(), searchIndexContentStateBean.getContentId());
        if (map.isEmpty()) {
            _$14.info((Object)("[SearchService] transferBeanToIndexDocument() \u5185\u5bb9\u4fe1\u606f\u4e22\u5931\uff0ccontentId:" + searchIndexContentStateBean.getContentId()));
            return null;
        }
        Document document = new Document();
        document.add((Fieldable)new Field("contentId", searchIndexContentStateBean.getContentId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("censor", searchIndexContentStateBean.getCensor().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("classId", searchIndexContentStateBean.getClassId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("modelId", searchIndexContentStateBean.getModelId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("siteId", searchIndexContentStateBean.getSiteId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("addDate", searchIndexContentStateBean.getIndexDate().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("title", map.get("title").toString(), Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        document.add((Fieldable)new Field("keywords", map.get("keywords") == null ? "" : map.get("keywords").toString(), Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        List list = _$3.retrieveModelFiledInfoBeanList(searchIndexContentStateBean.getModelId());
        if (list.isEmpty()) {
            _$14.info((Object)("[SearchService] transferBeanToIndexDocument() \u6a21\u578b\u5b57\u6bb5\u4fe1\u606f\u4e22\u5931\uff0cmodelId:" + searchIndexContentStateBean.getModelId()));
            return null;
        }
        ModelFiledInfoBean modelFiledInfoBean = null;
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            modelFiledInfoBean = (ModelFiledInfoBean)list.get(i);
            if (!Constant.COMMON.ON.equals(modelFiledInfoBean.getSearchFlag())) continue;
            if (StringUtil.isStringNotNull((String)map.get(modelFiledInfoBean.getFieldSign()))) {
                string = Jsoup.parse((String)map.get(modelFiledInfoBean.getFieldSign()).toString()).text();
            }
            document.add((Fieldable)new Field(modelFiledInfoBean.getFieldSign(), string, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        }
        return document;
    }

    public Object[] searchContentByKey(SiteGroupBean siteGroupBean, Long l, Long l2, Long[] longArray, Long l3, String string, int n, int n2, boolean bl) {
        String[] stringArray;
        String[] stringArray2;
        String string2;
        String string3;
        IndexSearcher indexSearcher;
        int n3 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        if ((indexSearcher = this.getIndexSearcher(string3 = SearchService.buildKey(string2 = SearchService.getIndexRootFullPathAndCheckDir(siteGroupBean), siteGroupBean.getSiteId()), string2)) == null) {
            return new Object[]{new ArrayList(), new Page(1, 0, 1)};
        }
        String[] stringArray3 = null;
        stringArray3 = bl ? new String[]{"title", "keywords"} : _$3.retrieveAllSiteSearchFieldStrArrayMode();
        int n4 = n2 * n3 - 1;
        int n5 = n4 - n3;
        if (l2 == null || l2 < 0L) {
            stringArray2 = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = l2.toString();
        }
        if (l != null && l != -1L) {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = l.toString();
        } else {
            stringArray = null;
        }
        Object[] objectArray = SearchService.search(indexSearcher, string, stringArray3, stringArray2, longArray, l3, stringArray, n5, n3);
        ArrayList<String> arrayList = new ArrayList<String>();
        Page page = null;
        if (objectArray != null) {
            page = new Page(n3, (Integer)objectArray[3], n2);
            TopDocs topDocs = (TopDocs)objectArray[0];
            try {
                ScoreDoc scoreDoc = null;
                if (topDocs != null) {
                    ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
                    for (int i = 0; i < scoreDocArray.length; ++i) {
                        scoreDoc = scoreDocArray[i];
                        Document document = indexSearcher.doc(scoreDoc.doc);
                        String string4 = document.get("contentId");
                        arrayList.add(string4);
                    }
                }
            }
            catch (Exception exception) {
                _$14.error((Object)exception);
            }
        }
        if (page == null) {
            page = new Page(1, 0, 1);
        }
        return new Object[]{arrayList, page};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildSearchIndex(List list, SiteGroupBean siteGroupBean, PublishStatusBean publishStatusBean) {
        ContentClassBean contentClassBean;
        int n;
        if (list == null) {
            return;
        }
        Long l = null;
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            l = Long.valueOf((String)list.get(n));
            contentClassBean = _$5.retrieveSingleClassBeanInfoByClassId(l);
            if (contentClassBean == null || contentClassBean.getClassId() < 0L) continue;
            n2 += this._$1(l, 1.0E18, _$13, null, null);
        }
        publishStatusBean.setPubCount(Long.valueOf(n2));
        try {
            this.mysqlEngine.beginTransaction();
            this.mysqlEngine.startBatch();
            for (n = 0; n < list.size(); ++n) {
                l = Long.valueOf((String)list.get(n));
                contentClassBean = _$5.retrieveSingleClassBeanInfoByClassId(l);
                if (contentClassBean == null || contentClassBean.getClassId() < 0L) continue;
                List list2 = _$4.retrieveNeedPublishContentByClassIDAndModelIdAndFlag(l, contentClassBean.getContentType(), 1.0E18, _$13, null, null);
                Double d = null;
                while (list2.size() > 0) {
                    Map map = null;
                    for (int i = 0; i < list2.size(); ++i) {
                        map = (Map)list2.get(i);
                        SearchIndexContentState searchIndexContentState = new SearchIndexContentState();
                        searchIndexContentState.setClassId(contentClassBean.getClassId());
                        searchIndexContentState.setContentId((Long)map.get("contentId"));
                        searchIndexContentState.setCensor((Integer)map.get("censorState"));
                        searchIndexContentState.setIndexDate((Date)map.get("addTime"));
                        searchIndexContentState.setEventFlag(Constant.JOB.SEARCH_INDEX_EDIT);
                        searchIndexContentState.setModelId((Long)map.get("modelId"));
                        searchIndexContentState.setSiteId(siteGroupBean.getSiteId());
                        this._$1.saveIndexContentState(searchIndexContentState);
                        publishStatusBean.setCurrent(publishStatusBean.getCurrent() + 1L);
                    }
                    Map map2 = (Map)list2.get(list2.size() - 1);
                    d = list2.size() == _$13.intValue() ? (Double)map2.get("orderIdFlag") : Double.valueOf(0.0);
                    list2 = _$4.retrieveNeedPublishContentByClassIDAndModelIdAndFlag(l, contentClassBean.getContentType(), d, _$13, null, null);
                }
            }
            this.mysqlEngine.executeBatch();
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    private int _$1(Long l, Double d, Integer n, Timestamp timestamp, Timestamp timestamp2) {
        ContentClassBean contentClassBean = _$5.retrieveSingleClassBeanInfoByClassId(l);
        List list = _$4.retrieveNeedPublishContentByClassIDAndModelIdAndFlag(l, contentClassBean.getContentType(), 1.0E18, _$13, null, null);
        Double d2 = null;
        int n2 = list.size();
        while (list.size() > 0) {
            Map map = (Map)list.get(list.size() - 1);
            d2 = list.size() == _$13.intValue() ? (Double)map.get("orderIdFlag") : Double.valueOf(0.0);
            list = _$4.retrieveNeedPublishContentByClassIDAndModelIdAndFlag(l, contentClassBean.getContentType(), d2, _$13, null, null);
            n2 += list.size();
        }
        return n2;
    }

    public void deleteSearchKeyInfo(List list) {
        Long l = null;
        for (int i = 0; i < list.size(); ++i) {
            l = StringUtil.getLongValue((String)list.get(i), -1L);
            if (l < 1L) continue;
            this._$1.deleteSearchKey(l);
        }
    }

    public List retrieveSearchKeyCountInfoBySiteId(Long l, Integer n) {
        return this._$1.querySearchKeyBySiteId(l, 0L, n);
    }

    public Object getSearchKeyInfoTag(String string, String string2) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        List list = null;
        int n = StringUtil.getIntValue(string, 1);
        int n2 = StringUtil.getIntValue(string2, 15);
        Page page = null;
        Long l = null;
        l = this._$1.querySearchKeyCountBySiteId(siteGroupBean.getSiteId());
        page = new Page(n2, l.intValue(), n);
        list = this._$1.querySearchKeyBySiteId(siteGroupBean.getSiteId(), page.getFirstResult(), n2);
        return new Object[]{list, page};
    }

    public static void main(String[] stringArray) throws IOException {
    }
}

