/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util;

import cn.com.mjsoft.framework.behavior.Behavior;
import cn.com.mjsoft.framework.exception.FrameworkException;
import cn.com.mjsoft.framework.util.MathUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import cn.com.mjsoft.framework.util.UUIDHexGenerator;
import cn.com.mjsoft.framework.util.jdk14zip.ZipEntry;
import cn.com.mjsoft.framework.util.jdk14zip.ZipInputStream;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class FileUtil {
    public static final String DEFAULT_CHARSET = "GBK";
    static final int _$4 = 8192;
    private static UUIDHexGenerator _$3 = new UUIDHexGenerator();
    private static Logger _$2 = Logger.getLogger(FileUtil.class);
    private static OpenOfficeConnection _$1 = null;

    public static void newFolder(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            System.out.println("\u65b0\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    public static void newFile(String string, String string2) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            String string3 = string2;
            printWriter.println(string3);
            fileWriter.close();
        }
        catch (Exception exception) {
            System.err.println("\u65b0\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    public static boolean delFile(String string) {
        _$2.info((Object)("\u5c06\u5220\u9664\u6587\u4ef6\uff1a" + string));
        try {
            String string2 = string;
            File file = new File(string2);
            if (file.isDirectory()) {
                _$2.error((Object)("\u8bd5\u56fe\u5220\u9664\u4e00\u4e2a\u76ee\u5f55! target:" + string));
                return false;
            }
            file.delete();
            if (file.exists()) {
                file.deleteOnExit();
            }
            return !file.exists();
        }
        catch (Exception exception) {
            _$2.error((Object)exception);
            exception.printStackTrace();
            return false;
        }
    }

    public static void delFolder(String string) {
        try {
            FileUtil.delAllFile(string, true);
            String string2 = string;
            string2 = string2.toString();
            File file = new File(string2);
            file.delete();
        }
        catch (Exception exception) {
            _$2.error((Object)"\u5220\u9664\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    public static void delAllFile(String string, boolean bl) {
        _$2.info((Object)("\u5c06\u5220\u9664\u7684\u6587\u4ef6\u7cfb\u7edfpath:" + string));
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
            _$2.info((Object)"\u4f5c\u4e3a\u5355\u6587\u4ef6\u5220\u9664");
            return;
        }
        String[] stringArray = file.list();
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = string.endsWith(File.separator) ? new File(string + stringArray[i]) : new File(string + File.separator + stringArray[i]);
            if (file2.isFile()) {
                file2.delete();
            }
            if (!file2.isDirectory()) continue;
            FileUtil.delAllFile(string + File.separator + stringArray[i], true);
            FileUtil.delFolder(string + File.separator + stringArray[i]);
        }
        if (bl) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String string, String string2) {
        _$2.info((Object)("copyFile() oldFile:" + string + " ,newPath:" + string2));
        File file = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            File file2 = new File(string);
            if (file2.exists()) {
                file = new File(string2);
                file.createNewFile();
                fileInputStream = new FileInputStream(string);
                fileOutputStream = new FileOutputStream(string2);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                FileUtil.writeFile(bufferedInputStream, filterOutputStream);
            }
        }
        catch (Exception exception) {
            _$2.error((Object)"\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean move(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = file.renameTo(new File(file2, file.getName()));
        return bl;
    }

    public static void copyFolder(String string, String string2) {
        try {
            new File(string2).mkdirs();
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray != null) {
                File file2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    file2 = string.endsWith(File.separator) ? new File(string + stringArray[i]) : new File(string + File.separator + stringArray[i]);
                    if (file2.isFile()) {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        FileOutputStream fileOutputStream = new FileOutputStream(string2 + File.separator + file2.getName().toString());
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        FileUtil.writeFile(bufferedInputStream, bufferedOutputStream);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        fileInputStream.close();
                        bufferedInputStream.close();
                        bufferedOutputStream.close();
                    }
                    if (!file2.isDirectory()) continue;
                    FileUtil.copyFolder(string + File.separator + stringArray[i], string2 + File.separator + stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    public static void copyOnlyFolder(String string, String string2, String string3) {
        try {
            File file;
            String[] stringArray;
            if (StringUtil.isStringNotNull(string3)) {
                if (string2.indexOf(string3) == -1) {
                    new File(string2).mkdirs();
                }
            } else {
                new File(string2).mkdirs();
            }
            if ((stringArray = (file = new File(string)).list()) != null) {
                File file2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    file2 = string.endsWith(File.separator) ? new File(string + stringArray[i]) : new File(string + File.separator + stringArray[i]);
                    if (!file2.isDirectory()) continue;
                    FileUtil.copyOnlyFolder(string + File.separator + stringArray[i], string2 + File.separator + stringArray[i], string3);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\u590d\u5236\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    public static void moveCopyFile(String string, String string2) {
        FileUtil.copyFile(string, string2);
        FileUtil.delFile(string);
    }

    public static void moveFolder(String string, String string2) {
        FileUtil.copyFolder(string, string2);
        FileUtil.delFolder(string);
    }

    public static File[] getAllFile(String string, FileFilter fileFilter) {
        File[] fileArray = null;
        if (StringUtil.isStringNull(string)) {
            return null;
        }
        try {
            File file = new File(string.trim());
            fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
        }
        catch (Exception exception) {
            System.err.println("\u53d6\u5f53\u524d\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u51fa\u9519,fullPath:" + string.trim());
            exception.printStackTrace();
        }
        return fileArray;
    }

    public static File[] getAllFile(String string) {
        return FileUtil.getAllFile(string, null);
    }

    public static Object[] getTXTFileContent(String string, List list, String string2) {
        _$2.info((Object)("[getTXTFileContent]{fullPath}:" + string + ", {rule}:" + list));
        Object[] objectArray = new Object[]{"", Integer.valueOf("0"), string2};
        if (StringUtil.isStringNull(string)) {
            _$2.info((Object)"\u8def\u5f84\u4e3a\u7a7a,\u5c06\u8fd4\u56de\u7a7a\u5b57\u7b26");
            return objectArray;
        }
        try {
            File file = new File(string.trim());
            if (!file.exists()) {
                _$2.info((Object)"\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                return objectArray;
            }
            if (!file.isFile() || file.isHidden()) {
                _$2.info((Object)"\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u6216\u88ab\u7cfb\u7edf\u9690\u85cf");
                return objectArray;
            }
            boolean bl = true;
            String string3 = file.getName();
            String string4 = "";
            if (list == null || list.size() == 0) {
                bl = false;
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    string4 = (String)list.get(i);
                    if (string3.lastIndexOf(string4) + string4.length() != string3.length()) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                _$2.info((Object)("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6587\u4ef6,fileName:" + string3));
                return objectArray;
            }
            if (StringUtil.isStringNull(string2)) {
                String string5 = FileUtil.getTXTFileCode(file);
                _$2.info((Object)("\u5f53\u524d\u5904\u7406\u6587\u672c\u7f16\u7801\u4e3a:" + string5 + ", \u6587\u4ef6\u540d:" + file.getName()));
                string2 = "UTF-8".equalsIgnoreCase(string5) ? "UTF-8" : DEFAULT_CHARSET;
            }
            Object[] objectArray2 = FileUtil.readTXTFileContent(file, string2);
            return new Object[]{objectArray2[0], objectArray2[1], string2};
        }
        catch (Exception exception) {
            System.out.println("\u53d6\u5f53\u524d\u8def\u5f84\u4e0b\u6240\u6709\u6587\u4ef6\u51fa\u9519,fullPath:" + string.trim());
            exception.printStackTrace();
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTXTFileContent(String string, String string2, String string3) {
        BufferedWriter bufferedWriter = null;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string2));
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static Object[] readTXTFileContent(File file, String string) {
        return FileUtil.readTXTFileContent(file, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] readTXTFileContent(File file, String string, Behavior behavior, Object[] objectArray) {
        Object[] objectArray2 = new Object[]{"", Integer.valueOf("0")};
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        boolean bl = false;
        if (behavior != null) {
            bl = true;
        }
        int n = 0;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            while (string2 != null) {
                ++n;
                string3 = string2 + "\n";
                if (bl && ((Boolean)behavior.operation(string3, objectArray)).booleanValue()) {
                    stringBuffer = new StringBuffer("");
                    break;
                }
                stringBuffer.append(string3);
                string2 = bufferedReader.readLine();
            }
            objectArray2[0] = stringBuffer.toString();
            objectArray2[1] = n;
            Object[] objectArray3 = objectArray2;
            return objectArray3;
        }
        catch (Exception exception) {
            _$2.error((Object)("\u8bfb\u53d6\u5b57\u7b26\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u6587\u4ef6\u4e3a:" + file.getPath()));
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return objectArray2;
    }

    public static String getTXTFileCode(File file) {
        String string = "";
        if (file == null || !file.exists()) {
            return string;
        }
        CodepageDetectorProxy codepageDetectorProxy = CodepageDetectorProxy.getInstance();
        codepageDetectorProxy.add((ICodepageDetector)new ParsingDetector(false));
        codepageDetectorProxy.add((ICodepageDetector)JChardetFacade.getInstance());
        Charset charset = null;
        try {
            charset = codepageDetectorProxy.detectCodepage(file.toURL());
        }
        catch (Exception exception) {
            _$2.error((Object)("\u83b7\u53d6\u6587\u672c\u6587\u4ef6\u7f16\u7801\u51fa\u73b0\u9519\u8bef,File:" + file.getPath()));
            exception.printStackTrace();
        }
        if (charset != null) {
            string = charset.name();
        }
        return string;
    }

    public static void writeFile(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                outputStream.flush();
                n = inputStream.read(byArray);
            }
        }
        catch (Exception exception) {
            _$2.error((Object)"\u5199\u5165\u6587\u4ef6\u51fa\u9519");
            _$2.error((Object)exception);
        }
    }

    public static Map unZipFile(String string, String string2, boolean bl) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry(DEFAULT_CHARSET);
            String string3 = "";
            bufferedInputStream = new BufferedInputStream(zipInputStream);
            while (zipEntry != null) {
                string3 = zipEntry.getName();
                File file = null;
                _$2.info((Object)("[ZIP] name:" + string3));
                if (zipEntry.isDirectory()) {
                    file = new File(string2 + string3);
                    file.mkdirs();
                } else {
                    if (string3.indexOf("Thumbs.db") == -1) {
                        if (bl) {
                            String string4 = StringUtil.subString(string3, string3.lastIndexOf("."), string3.length());
                            file = new File(string2 + _$3.generate() + string4);
                        } else {
                            file = new File(string2 + string3);
                        }
                        file.createNewFile();
                        fileOutputStream = new FileOutputStream(file);
                        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        FileUtil.writeFile(bufferedInputStream, bufferedOutputStream);
                        treeMap.put(StringUtil.subString(string3, string3.lastIndexOf("/") + 1, string3.length()), file.getPath());
                    }
                    bufferedOutputStream.flush();
                    fileOutputStream.close();
                    bufferedOutputStream.close();
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry(DEFAULT_CHARSET);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$2.error((Object)("\u89e3\u538bZIP\u6587\u4ef6\u51fa\u9519,zip file:" + string + exception));
            throw new FrameworkException("\u89e3\u538bZIP\u6587\u4ef6\u51fa\u9519,zip file:" + string);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                _$2.error((Object)"\u5173\u95ed\u6d41\u51fa\u9519");
                iOException.printStackTrace();
            }
        }
        return treeMap;
    }

    public static void unZip(String string) {
        byte[] byArray = new byte[512];
        int n = -1;
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                org.apache.tools.zip.ZipEntry zipEntry = (org.apache.tools.zip.ZipEntry)enumeration.nextElement();
                File file = new File(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                n = inputStream.read(byArray);
                while (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                fileOutputStream.close();
                inputStream.close();
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void zip(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file2.exists()) {
            throw new RuntimeException(string2 + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            CheckedOutputStream checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)checkedOutputStream);
            String string3 = "";
            FileUtil.zip(file2, zipOutputStream, string3);
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void zip(String string, List list) {
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            CheckedOutputStream checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)checkedOutputStream);
            String string2 = "";
            FileUtil.zip(list, zipOutputStream, string2);
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void zip(File file, ZipOutputStream zipOutputStream, String string) {
        if (file.isDirectory()) {
            FileUtil.zipDirectory(file, zipOutputStream, string);
        } else {
            FileUtil.zipFile(file, zipOutputStream, string);
        }
    }

    public static void zip(List list, ZipOutputStream zipOutputStream, String string) {
        FileUtil.zipSomeFile(list, zipOutputStream, string);
    }

    public static void zipDirectory(File file, ZipOutputStream zipOutputStream, String string) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            FileUtil.zip(fileArray[i], zipOutputStream, string + file.getName() + "/");
        }
    }

    public static void zipSomeFile(List list, ZipOutputStream zipOutputStream, String string) {
        File file = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                int n;
                file = (File)list.get(i);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                org.apache.tools.zip.ZipEntry zipEntry = new org.apache.tools.zip.ZipEntry(string + file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = new byte[8192];
                while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void zipFile(File file, ZipOutputStream zipOutputStream, String string) {
        if (!file.exists()) {
            return;
        }
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            org.apache.tools.zip.ZipEntry zipEntry = new org.apache.tools.zip.ZipEntry(string + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void refreshFileList(String string, List list) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null || list == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                FileUtil.refreshFileList(fileArray[i].getAbsolutePath(), list);
                continue;
            }
            list.add(fileArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createXML(String string) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("book");
        element.addAttribute("name", "\u6211\u7684\u56fe\u4e66");
        Element element2 = element.addElement("price");
        element2.setText("21.22");
        Element element3 = element.addElement("author");
        element3.setText("\u674e\u56db");
        element3.addAttribute("ID", "001");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            XMLWriter xMLWriter = new XMLWriter((OutputStream)fileOutputStream);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static File convertOfficeToHtmlFile(File file, File file2) {
        if (!file.exists()) {
            return null;
        }
        try {
            if (_$1 == null) {
                _$1 = new SocketOpenOfficeConnection(8100);
                _$1.connect();
            }
            OpenOfficeDocumentConverter openOfficeDocumentConverter = new OpenOfficeDocumentConverter(_$1);
            openOfficeDocumentConverter.convert(file, file2);
        }
        catch (ConnectException connectException) {
            _$2.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684openoffice\u8fde\u63a5,\u8bf7\u68c0\u67e5JtopCMS\u7cfb\u7edf\u53d8\u91cf!");
            try {
                _$1.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            _$1 = null;
            throw new FrameworkException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684openoffice\u8fde\u63a5,\u8bf7\u68c0\u67e5JtopCMS\u7cfb\u7edf\u53d8\u91cf!");
        }
        catch (Exception exception) {
            _$2.error((Object)("\u8f6c\u6362Office\u6587\u6863\u5931\u8d25,\u76ee\u6807Office\u6587\u4ef6:" + file.toString()));
            if (_$1 != null) {
                try {
                    _$1.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            _$1 = null;
            throw new FrameworkException("\u8f6c\u6362Office\u6587\u6863\u5931\u8d25,\u76ee\u6807Office\u6587\u4ef6:" + file.toString());
        }
        return file2;
    }

    public static String clearWordFormat(String string) {
        string = string.replaceAll("(<P)([^>]*)(>.*?)(<\\/P>)", "<p$3</p>");
        string = string.replaceAll("<[/]?(font|FONT|span|SPAN|xml|XML|del|DEL|ins|INS|meta|META|[ovwxpOVWXP]:\\w+)[^>]*?>", "");
        string = string.replaceAll("<([^>]*)(?:lang|LANG|class|CLASS|style|STYLE|size|SIZE|face|FACE|[ovwxpOVWXP]:\\w+)=(?:'[^']*'|\"\"[^\"\"]*\"\"|[^>]+)([^>]*)>", "<$1$2>");
        int n = string.indexOf("<STYLE");
        int n2 = string.indexOf("</STYLE>") + 8;
        String string2 = StringUtil.subString(string, n, n2);
        string = string.replace(string2, "");
        return string;
    }

    public static String changeFileSizeToStr(long l) {
        long l2 = Double.valueOf(MathUtil.div(l, 1024.0, 0)).longValue();
        String string = "";
        string = l2 > 1024L ? MathUtil.div(l, 1048576.0, 2) + " MB" : MathUtil.div(l, 1024.0, 2) + " KB";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jsp");
        arrayList.add("html");
        arrayList.add("htm");
        FileUtil.unZipFile("d:/xxx1.zip", "d:/xxx11", false);
    }
}

