/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.P6Util;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class Subclasser {
    public static String DELIMITER = System.getProperty("file.separator");
    public static String NEWLINE = System.getProperty("line.separator");
    public static String INDENT = "  ";
    public static String DEFAULT_PACKAGE = "com.p6spy.engine.subclass";
    protected Class parentClass;
    protected String outputDir;
    protected String packageName;
    protected String outputName;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public Subclasser() {
    }

    public Subclasser(String className) throws ClassNotFoundException {
        this(P6Util.forName(className));
    }

    public Subclasser(Class c) {
        this.setParentClass(c);
    }

    public static void main(String[] args) {
        int size = args.length;
        int i = 0;
        while (i < size) {
            try {
                Subclasser sub = new Subclasser(args[i]);
                sub.createSubClass();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void createSubClass() throws Exception {
        if (this.parentClass == null) {
            throw new Exception("Parent Class must not be null");
        }
        if (!(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = Subclasser.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).isAssignableFrom(this.parentClass)) {
            throw new Exception("Parent Class " + this.parentClass.getName() + " is not an instanceof javax.sql.DataSource");
        }
        File output = this.getOutputFile();
        if (output.getParent() != null) {
            output.getParentFile().mkdirs();
        }
        output.createNewFile();
        FileWriter writer = new FileWriter(output);
        writer.write(this.writeHeader());
        writer.write(this.writeConstructors());
        writer.write(this.overrideConnection());
        writer.write(this.writeFooter());
        writer.flush();
        writer.close();
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(Class c) {
        this.parentClass = c;
    }

    public String getParentPackage() {
        String rv = null;
        if (this.parentClass != null) {
            Package pack = this.parentClass.getPackage();
            rv = pack != null ? pack.getName() : this.packageName(this.parentClass.getName());
        }
        return rv;
    }

    public File getOutputFile() {
        String dir = this.getOutputDir();
        String fullDir = this.packToDir(this.getOutputPackage());
        String name = this.getOutputName();
        if (dir != "") {
            fullDir = dir + DELIMITER + fullDir;
        }
        return new File(fullDir, name + ".java");
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.outputDir = "scratch";
        }
        return this.outputDir;
    }

    public void setOutputDir(String value) {
        this.outputDir = value;
    }

    public String getOutputPackage() {
        if (this.packageName == null) {
            this.packageName = DEFAULT_PACKAGE;
        }
        return this.packageName;
    }

    public void setOutputPackage(String value) {
        this.packageName = value;
    }

    public String getOutputName() {
        if (this.outputName == null && this.parentClass != null) {
            this.outputName = "P6" + this.baseName(this.parentClass.getName());
        }
        return this.outputName;
    }

    public void setOutputName(String value) {
        this.outputName = value;
    }

    public String baseName(String clazz) {
        String rv = null;
        int pos = clazz.lastIndexOf(".");
        if (pos != -1) {
            rv = clazz.substring(pos + 1);
        }
        return rv;
    }

    public String packageName(String clazz) {
        String rv = null;
        int pos = clazz.lastIndexOf(".");
        if (pos != -1) {
            rv = clazz.substring(0, pos);
        }
        return rv;
    }

    public String packToDir(String pack) {
        StringBuffer sb = new StringBuffer();
        int length = pack.length();
        int i = 0;
        while (i < length) {
            char c = pack.charAt(i);
            if (c == '.') {
                sb.append(DELIMITER);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String writeHeader() throws Exception {
        StringBuffer sb = new StringBuffer();
        String parentPack = this.getParentPackage();
        sb.append("// this class generated by " + this.getClass());
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("package " + this.getOutputPackage() + ";");
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("import com.p6spy.engine.spy.*;" + NEWLINE);
        sb.append("import java.sql.*;" + NEWLINE);
        sb.append("import javax.sql.*;" + NEWLINE);
        sb.append("import " + parentPack + ".*;" + NEWLINE);
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("public class " + this.getOutputName() + " extends " + this.getParentClass().getName() + " {");
        sb.append(NEWLINE);
        return sb.toString();
    }

    public String writeConstructors() throws Exception {
        StringBuffer sb = new StringBuffer();
        Class parent = this.getParentClass();
        Constructor<?>[] conList = parent.getDeclaredConstructors();
        int length = conList.length;
        if (length == 0) {
            throw new Exception("No constructors found; is " + parent + " an interface?");
        }
        int i = 0;
        while (i < length) {
            Constructor<?> c = conList[i];
            int mods = c.getModifiers();
            Class<?>[] params = c.getParameterTypes();
            Class<?>[] exceps = c.getExceptionTypes();
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(Modifier.toString(mods));
            sb.append(" " + this.getOutputName());
            sb.append(" (");
            int j = 0;
            while (j < params.length) {
                Class<?> param = params[j];
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(param.getName());
                sb.append(" p" + j);
                ++j;
            }
            sb.append(")");
            if (exceps.length > 0) {
                sb.append(" throws ");
                int j2 = 0;
                while (j2 < exceps.length) {
                    Class<?> ex = exceps[j2];
                    if (j2 > 0) {
                        sb.append(", ");
                    }
                    sb.append(ex.getName());
                    ++j2;
                }
            }
            sb.append(" {");
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(INDENT);
            sb.append("super(");
            int j3 = 0;
            while (j3 < params.length) {
                Class<?> param = params[j3];
                if (j3 > 0) {
                    sb.append(", ");
                }
                sb.append(" p" + j3);
                ++j3;
            }
            sb.append(");");
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append("}");
            ++i;
        }
        return sb.toString();
    }

    public String overrideConnection() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.overrideConnection("", ""));
        sb.append(this.overrideConnection("String username, String password", "username, password"));
        return sb.toString();
    }

    public String overrideConnection(String signature, String names) {
        String value = "" + NEWLINE + INDENT + "public Connection getConnection(" + signature + ") throws SQLException {" + NEWLINE + INDENT + INDENT + "return P6SpyDriverCore.wrapConnection(super.getConnection(" + names + "));" + NEWLINE + INDENT + "};" + NEWLINE + "";
        return value;
    }

    public String writeFooter() {
        return NEWLINE + "}" + NEWLINE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

