/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.common;

import com.letousky.common.HibernateUtil;
import com.letousky.common.IBaseDAO;
import com.letousky.exception.LotteryException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BaseDAO
extends HibernateDaoSupport
implements IBaseDAO {
    public static final Logger __logger = Logger.getLogger(BaseDAO.class);
    static /* synthetic */ Class class$0;

    public Object doSave(Object entity) throws LotteryException {
        super.getHibernateTemplate().save(entity);
        this.getHibernateTemplate().flush();
        return entity;
    }

    public void doUpdate(Object entity) throws LotteryException {
        super.getHibernateTemplate().update(entity);
        this.getHibernateTemplate().flush();
    }

    public void doUpdate(Object entity, LockMode lockMode) throws LotteryException {
        Session session = HibernateUtil.currentSession();
        Transaction tx = session.beginTransaction();
        session.update(entity);
        tx.commit();
    }

    public int doUpdateAll(String sql) throws LotteryException {
        Session session = null;
        try {
            session = this.getSession();
            Query query = session.createQuery(sql);
            int n = query.executeUpdate();
            return n;
        }
        finally {
            super.releaseSession(session);
        }
    }

    public void doDelete(Object entity) throws LotteryException {
        super.getHibernateTemplate().delete(entity);
    }

    public void doDeleteAll(List entitys) throws LotteryException {
        super.getHibernateTemplate().deleteAll((Collection)entitys);
    }

    public void doDeleteAll(Class clazz, String keyName, String keyValue) throws LotteryException {
        Session session = null;
        try {
            session = this.getSession();
            String sql = "delete from " + clazz.getName() + " t where t." + keyName + " = " + keyValue;
            Query query = session.createQuery(sql);
            query.executeUpdate();
        }
        finally {
            super.releaseSession(session);
        }
    }

    public Object find(Class clazz, long keyValue) throws LotteryException {
        Object obj = super.getHibernateTemplate().load(clazz, (Serializable)new Long(keyValue));
        this.initialize(obj);
        return obj;
    }

    public Object find(Class clazz, String keyName, String keyValue) throws LotteryException {
        List list = super.getHibernateTemplate().find("from " + clazz.getName() + " as s where s." + keyName + " = '" + keyValue + "'");
        if (!list.isEmpty() && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Object find(Class clazz, String keyName, long keyValue) throws LotteryException {
        String sql = "from " + clazz.getName() + " s where s." + keyName + " = " + keyValue;
        List list = super.getHibernateTemplate().find(sql);
        if (!list.isEmpty() && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Object findMaxFiled(Class clazz, String keyName) throws LotteryException {
        List list = super.getHibernateTemplate().find("select max(s." + keyName + ") from " + clazz.getName() + " s");
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List findList(String sql) throws LotteryException {
        Session session = null;
        try {
            session = super.getSession();
            Query query = session.createQuery(sql);
            ArrayList list = query.list();
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            super.releaseSession(session);
        }
    }

    public List findList(String sql, int pageNum, int pageCount) throws LotteryException {
        ArrayList arrayList;
        Session session = null;
        try {
            int first = 0;
            first = pageNum <= 0 ? 0 : (pageNum - 1) * pageCount;
            session = super.getSession();
            Query query = session.createQuery(sql);
            query.setFirstResult(first);
            query.setMaxResults(pageCount);
            ArrayList list = query.list();
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            super.releaseSession(session);
            throw throwable;
        }
        super.releaseSession(session);
        return arrayList;
    }

    public int findListCount(String sql) throws LotteryException {
        int results = 0;
        List list = super.getHibernateTemplate().find(sql);
        if (!list.isEmpty()) {
            results = Integer.parseInt(list.get(0).toString());
        }
        return results;
    }

    public void initialize(Object child) throws LotteryException {
        super.getHibernateTemplate().initialize(child);
    }
}

