/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.common;

import com.letousky.common.ServiceFactory;
import com.letousky.common.ThreadLocal;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateUtil {
    public static final SessionFactory sessionFactory;
    public static final ThreadLocal session;

    static {
        try {
            sessionFactory = (SessionFactory)ServiceFactory.getInstance().getService("sessionFactory");
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
        session = new ThreadLocal();
    }

    public static Session currentSession() throws HibernateException {
        Session s = (Session)session.get();
        if (s == null) {
            s = sessionFactory.openSession();
            session.set(s);
        }
        return s;
    }

    public static void closeSession() throws HibernateException {
        Session s = (Session)session.get();
        if (s != null) {
            s.close();
        }
        session.set(null);
    }
}

