/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.common;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServiceFactory {
    private static ApplicationContext ctxt;
    private static final Map _services;
    private static ServiceFactory serviceFactory;

    static {
        _services = new HashMap();
        serviceFactory = null;
    }

    private ServiceFactory() {
    }

    public static synchronized ServiceFactory getInstance() {
        if (serviceFactory == null) {
            serviceFactory = new ServiceFactory();
            if (ctxt == null) {
                ServiceFactory.openSession();
            }
        }
        return serviceFactory;
    }

    private static void openSession() {
        try {
            ctxt = new ClassPathXmlApplicationContext("ApplicationContext.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ApplicationContext getContext() {
        if (ctxt == null) {
            ServiceFactory.getInstance();
        }
        return ctxt;
    }

    public Object getService(String serviceName) {
        Object object = _services.get(serviceName);
        if (object == null) {
            _services.put(serviceName, ctxt.getBean(serviceName));
            return _services.get(serviceName);
        }
        return object;
    }
}

