/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.connector;

import com.letousky.util.MD5;
import com.letousky.util.TimeUtil;

public class Message {
    private String version;
    private String channelNo;
    private String requestNo;
    private String dataType;
    private String requestType;
    private String operaterCode;
    private String operaterNo;
    private String operaterTime;
    private String tradeNo;
    private String tradeTime;
    private String dataVerify;
    private String dataLength;
    private String body;

    public Message() {
        this.getProperties();
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parseString(this.version, 4));
        buffer.append(this.parseString(this.channelNo, 4));
        buffer.append(this.parseString(this.requestNo, 4));
        buffer.append(this.parseString(this.dataType, 20));
        buffer.append(this.parseString(this.requestType, 4));
        buffer.append(this.parseString(this.operaterCode, 8));
        buffer.append(this.parseString(this.operaterNo, 25));
        this.operaterTime = TimeUtil.getDate("yyyyMMddHHmmss");
        buffer.append(this.parseString(this.operaterTime, 24));
        buffer.append(this.parseString(this.tradeNo, 25));
        buffer.append(this.parseString(this.tradeTime, 24));
        this.dataVerify = new MD5().md5(this.body);
        buffer.append(this.parseString(this.dataVerify, 32));
        buffer.append(this.parseString(this.dataLength, 8));
        buffer.append(this.body);
        return buffer.toString();
    }

    private String parseString(String value, int length) {
        int size = value.length();
        int num = length - size;
        if (num > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < num) {
                buffer.append(" ");
                ++i;
            }
            value = String.valueOf(value) + buffer.toString();
        } else {
            value = value.substring(0, length);
        }
        return value;
    }

    private void getProperties() {
        this.tradeNo = "";
        this.tradeTime = "";
    }

    public String getChannelNo() {
        return this.channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo;
    }

    public String getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(String dataLength) {
        this.dataLength = dataLength;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataVerify() {
        return this.dataVerify;
    }

    public void setDataVerify(String dataVerify) {
        this.dataVerify = dataVerify;
    }

    public String getOperaterTime() {
        return this.operaterTime;
    }

    public void setOperaterTime(String operaterTime) {
        this.operaterTime = operaterTime;
    }

    public String getRequestNo() {
        return this.requestNo;
    }

    public void setRequestNo(String requestNo) {
        this.requestNo = requestNo;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTradeTime() {
        return this.tradeTime;
    }

    public void setTradeTime(String tradeTime) {
        this.tradeTime = tradeTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.dataLength = "" + body.getBytes().length;
    }

    public String getOperaterCode() {
        return this.operaterCode;
    }

    public void setOperaterCode(String operaterCode) {
        this.operaterCode = operaterCode;
    }

    public String getOperaterNo() {
        return this.operaterNo;
    }

    public void setOperaterNo(String operaterNo) {
        this.operaterNo = operaterNo;
    }
}

