/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.connector.http;

import com.letousky.connector.AbstractSourceTool;
import com.letousky.exception.LotteryException;
import com.letousky.util.Base64Util;
import com.letousky.util.ZipStringUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpConnectionPool
extends AbstractSourceTool {
    private static final String CHARCODE = "GBK";
    private static String path = null;
    private URL url = null;
    private HttpURLConnection connection = null;
    private DataOutputStream dataOut = null;
    private DataInputStream dataIn = null;

    private HttpURLConnection createURLConnection() throws LotteryException {
        try {
            if (path == null) {
                path = this.con.getUrlPath();
            }
            this.url = new URL(path);
            this.connection = (HttpURLConnection)this.url.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setUseCaches(false);
            this.connection.setConnectTimeout(0);
            this.connection.setReadTimeout(0);
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            return this.connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LotteryException("C001", "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38!");
        }
    }

    public String invoke(String message) throws LotteryException {
        try {
            this.createURLConnection();
            message = ZipStringUtil.compress(message);
            message = Base64Util.encode(message);
            this.write(message);
            String string = this.read();
            return string;
        }
        finally {
            this.releaseSource();
        }
    }

    private void write(String message) throws LotteryException {
        ByteArrayOutputStream out = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                out.write(message.getBytes());
                this.dataOut = new DataOutputStream(this.connection.getOutputStream());
                this.dataOut.write(out.toByteArray());
                out.flush();
                this.dataOut.flush();
            }
            catch (Exception e) {
                throw new LotteryException("C001", "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38!");
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (this.dataOut != null) {
                    this.dataOut.close();
                }
            }
            catch (IOException e) {
                out = null;
                this.dataOut = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String read() throws LotteryException {
        ByteArrayOutputStream out = null;
        try {
            String bodyMessage;
            this.dataIn = new DataInputStream(this.connection.getInputStream());
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            while (true) {
                int n;
                if ((n = this.dataIn.read(buffer)) <= 0) {
                    bodyMessage = new String(out.toByteArray(), CHARCODE);
                    bodyMessage = Base64Util.decode(bodyMessage);
                    bodyMessage = ZipStringUtil.uncompress(bodyMessage);
                    out.flush();
                    if (bodyMessage.length() >= 182) break;
                    throw new Exception();
                }
                out.write(buffer, 0, n);
            }
            String string = bodyMessage.substring(182);
            return string;
        }
        catch (Exception e) {
            throw new LotteryException("C001", "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38!");
        }
        finally {
            try {
                if (this.dataIn != null) {
                    this.dataIn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                out = null;
                this.dataIn = null;
            }
        }
    }

    public void releaseSource() {
        try {
            if (this.dataOut != null) {
                this.dataOut.close();
            }
        }
        catch (IOException e) {
            this.dataOut = null;
        }
        try {
            if (this.dataIn != null) {
                this.dataIn.close();
            }
        }
        catch (IOException e) {
            this.dataIn = null;
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.url = null;
    }

    public static void main(String[] args) {
        new HttpConnectionPool().invoke("");
    }
}

