/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.connector.soap;

import com.letousky.connector.AbstractSourceTool;
import com.letousky.exception.LotteryException;
import com.letousky.util.Base64Util;
import com.letousky.util.ZipStringUtil;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

public class SoapConnectionPool
extends AbstractSourceTool {
    private static Call call = null;

    private void getCall() throws LotteryException {
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            call.setOperationName(new QName(this.con.getUrlPath(), this.con.getMethodName()));
            call.setTargetEndpointAddress(new URL(this.con.getUrlPath()));
        }
        catch (Exception e) {
            throw new LotteryException("C001", "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String invoke(String message) throws LotteryException {
        try {
            this.getCall();
            message = ZipStringUtil.compress(message);
            message = Base64Util.encode(message);
            String value = (String)call.invoke(new Object[]{message});
            value = Base64Util.decode(value);
            value = ZipStringUtil.uncompress(value);
            if (value == null) throw new LotteryException("C001", "\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef!");
            if (value.length() < 182) {
                throw new LotteryException("C001", "\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef!");
            }
            String string = value.substring(182);
            return string;
        }
        catch (Exception e) {
            throw new LotteryException("C001", "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38!");
        }
        finally {
            this.releaseSource();
        }
    }

    public void releaseSource() {
        if (call != null) {
            call = null;
        }
    }
}

