/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.invoker;

import com.letousky.exception.LotteryException;
import com.letousky.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class BusinessInvokerFormatter {
    public static final int DEFAULT_BUFFER_SIZE = 512;

    public String formatString(String requestData, String formatAs) throws LotteryException {
        if (formatAs == null) {
            return requestData;
        }
        String tempString = requestData;
        if (tempString == null) {
            return null;
        }
        if (formatAs.equalsIgnoreCase("lowercase")) {
            tempString = tempString.toLowerCase();
        } else if (formatAs.equalsIgnoreCase("uppercase")) {
            tempString = tempString.toUpperCase();
        }
        return tempString;
    }

    public String formatString(Object requestData) throws LotteryException {
        if (requestData == null) {
            return " ";
        }
        return this.formatString(requestData.toString(), null);
    }

    public String formatString(String requestData) throws LotteryException {
        if (requestData == null) {
            requestData = " ";
        }
        return this.formatString(requestData.toString(), null);
    }

    public String unformatString(String requestData, String unformatAs) throws LotteryException {
        if (unformatAs == null) {
            return requestData;
        }
        String tempString = requestData;
        if (tempString == null) {
            return null;
        }
        if (unformatAs.equalsIgnoreCase("lowercase")) {
            tempString = tempString.toLowerCase();
        } else if (unformatAs.equalsIgnoreCase("uppercase")) {
            tempString = tempString.toUpperCase();
        }
        return tempString;
    }

    public String unformatString(String requestData) throws LotteryException {
        return this.unformatString(requestData, null);
    }

    public String formatInteger(Object requestData, int size, String byteOrdering) throws LotteryException {
        long value = 0L;
        if (byteOrdering == null) {
            byteOrdering = "pc";
        }
        if (requestData instanceof Long) {
            value = (Long)requestData;
        } else if (requestData instanceof Integer) {
            value = ((Integer)requestData).longValue();
        } else if (requestData instanceof Short) {
            value = ((Short)requestData).longValue();
        } else if (requestData instanceof Byte) {
            value = ((Byte)requestData).longValue();
        } else {
            requestData.getClass().getName();
            throw new LotteryException("Error Formater");
        }
        String aString = new String(StringUtil.longAsCharArray(size, value));
        if (byteOrdering.equalsIgnoreCase("host")) {
            aString = new StringBuffer(aString).reverse().toString();
        }
        return aString;
    }

    public String formatInteger(Object requestData) throws LotteryException {
        return this.formatInteger(requestData, 4, "pc");
    }

    public Object unformatInteger(String requestData, int size, String byteOrdering, boolean signRule) throws LotteryException {
        if (byteOrdering == null) {
            byteOrdering = "pc";
        }
        long value = 0L;
        if (requestData.length() != size) {
            String tempString = requestData;
            if (requestData.length() > 15) {
                tempString = String.valueOf(requestData.substring(0, 15)) + "...";
            }
            throw new LotteryException("Invalid Argument. Length is not valid. Format: " + requestData + ", Process: parse" + ", String: " + tempString);
        }
        if (size == 0) {
            value = 0L;
        }
        char[] charArray = requestData.toCharArray();
        if (byteOrdering.equalsIgnoreCase("host")) {
            charArray = new StringBuffer(requestData).reverse().toString().toCharArray();
        }
        value = signRule ? StringUtil.signedCharArrayToLong(charArray) : StringUtil.charArrayToLong(charArray);
        int sizeFormat = size;
        if (sizeFormat == 1) {
            return new Byte((byte)value);
        }
        if (sizeFormat == 2) {
            return new Short((short)value);
        }
        if (sizeFormat == 3 || sizeFormat == 4) {
            return new Integer((int)value);
        }
        if (sizeFormat > 4 && sizeFormat < 9) {
            return new Long(value);
        }
        return null;
    }

    public Object unformatInteger(String requestData) throws LotteryException {
        return this.unformatInteger(requestData, 4, "pc", true);
    }

    public String formatNumericString(String requestData, int decPlaces, char decimalsSepChar, char thousandsSepChar, boolean isShowDecimalsSep, boolean isShowThousandsSep, String signRule, String usePositiveSign) throws LotteryException {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMinimumFractionDigits(decPlaces);
        formatter.setMinimumFractionDigits(decPlaces);
        DecimalFormatSymbols fs = formatter.getDecimalFormatSymbols();
        fs.setDecimalSeparator(decimalsSepChar);
        fs.setGroupingSeparator(thousandsSepChar);
        formatter.setDecimalFormatSymbols(fs);
        int intSignRule = 1;
        if (signRule.equalsIgnoreCase("suffix")) {
            intSignRule = 2;
        } else if (signRule.equalsIgnoreCase("parenthesis")) {
            intSignRule = 3;
        }
        int intUsePositiveSign = 1;
        if (usePositiveSign.equalsIgnoreCase("yes")) {
            intUsePositiveSign = 2;
        } else if (signRule.equalsIgnoreCase("blank")) {
            intUsePositiveSign = 3;
        }
        this.setSignPolicy(formatter, intUsePositiveSign, intSignRule);
        double num = 0.0;
        try {
            Double convert = Double.valueOf(requestData);
            num = convert;
        }
        catch (Exception ex) {
            throw new LotteryException("Invalid Argument: " + requestData + "can not be parsed as Long" + ". Format: " + requestData + ", Process: format" + ", String: " + requestData);
        }
        String result = formatter.format(num);
        int minDigits = formatter.getMinimumFractionDigits();
        char decimalSymbol = formatter.getDecimalFormatSymbols().getDecimalSeparator();
        if (!isShowDecimalsSep && minDigits > 0) {
            int posDecimalSeparator = result.indexOf(decimalSymbol);
            result = String.valueOf(result.substring(0, posDecimalSeparator)) + result.substring(posDecimalSeparator + 1);
        }
        return result;
    }

    public String formatNumericString(String requestData) throws LotteryException {
        int decPlaces = 0;
        char decimalsSepChar = '.';
        char thousandsSepChar = ',';
        boolean isShowDecimalsSep = true;
        boolean isShowThousandsSep = true;
        String signRule = "suffix";
        String usePositiveSign = "yes";
        return this.formatNumericString(requestData, decPlaces, decimalsSepChar, thousandsSepChar, isShowDecimalsSep, isShowThousandsSep, signRule, usePositiveSign);
    }

    public Number unformatNumericString(String requestData, int decPlaces, char decimalsSepChar, char thousandsSepChar, boolean isShowDecimalsSep) throws LotteryException {
        try {
            DecimalFormat formatter = new DecimalFormat();
            formatter.setMinimumFractionDigits(decPlaces);
            formatter.setMinimumFractionDigits(decPlaces);
            DecimalFormatSymbols fs = formatter.getDecimalFormatSymbols();
            fs.setDecimalSeparator(decimalsSepChar);
            fs.setGroupingSeparator(thousandsSepChar);
            formatter.setDecimalFormatSymbols(fs);
            int decP = decPlaces;
            if (!isShowDecimalsSep && decP > 0) {
                int lengthSuffix_SignRule = formatter.parse(requestData).doubleValue() > 0.0 ? formatter.getPositiveSuffix().length() : formatter.getNegativeSuffix().length();
                int posDecimalSeparator = requestData.length() - (decP + lengthSuffix_SignRule);
                if (posDecimalSeparator < 0) {
                    String tempString = requestData;
                    if (requestData.length() > 15) {
                        tempString = String.valueOf(requestData.substring(0, 15)) + "...";
                    }
                    throw new LotteryException("Invalid Argument: " + requestData + " The argument length is lower than the expected length" + ". Format: " + requestData + ", Process: unformatField" + ", String: " + tempString);
                }
                requestData = String.valueOf(requestData.substring(0, posDecimalSeparator)) + decimalsSepChar + requestData.substring(posDecimalSeparator);
            }
            return formatter.parse(requestData);
        }
        catch (ParseException e) {
            String tempString = requestData;
            if (requestData.length() > 15) {
                tempString = String.valueOf(requestData.substring(0, 15)) + "...";
            }
            throw new LotteryException("Invalid Argument: " + requestData + "can not be parsed to a Number" + ". Format: " + requestData + ", Process: unformatField" + ", String: " + tempString);
        }
    }

    public Number unformatNumericString(String requestData) throws LotteryException {
        int decPlaces = 0;
        char decimalsSepChar = '.';
        char thousandsSepChar = ',';
        boolean isShowDecimalsSep = true;
        return this.unformatNumericString(requestData, decPlaces, decimalsSepChar, thousandsSepChar, isShowDecimalsSep);
    }

    public String formatFloat(Object requestData, int size, String byteOrdering) throws LotteryException {
        Float floatValue = null;
        Double doubleValue = null;
        if (requestData instanceof Float) {
            if (size == 4) {
                floatValue = (Float)requestData;
            } else {
                doubleValue = new Double(((Float)requestData).doubleValue());
            }
        } else if (requestData instanceof Double) {
            if (size == 4) {
                floatValue = new Float(((Double)requestData).floatValue());
            } else {
                doubleValue = (Double)requestData;
            }
        } else {
            String className = null;
            if (requestData != null) {
                className = requestData.getClass().getName();
            }
            throw new LotteryException("Invalid Class: class " + className + " is not valid " + ". Format: " + requestData + ", Process: formatField");
        }
        String aString = null;
        aString = floatValue != null ? new String(StringUtil.longAsCharArray(size, Float.floatToIntBits(floatValue.floatValue()))) : new String(StringUtil.longAsCharArray(size, Double.doubleToLongBits(doubleValue)));
        if (byteOrdering.equalsIgnoreCase("host")) {
            aString = new StringBuffer(aString).reverse().toString();
        }
        return aString;
    }

    public String formatFloat(Object requestData) throws LotteryException {
        return this.formatFloat(requestData, 4, "pc");
    }

    public Object unformatFloat(String requestData, int size, String byteOrdering) throws LotteryException {
        float floatValue = 0.0f;
        double doubleValue = 0.0;
        String tempString = requestData;
        if (size == 4) {
            if (byteOrdering.equalsIgnoreCase("host")) {
                tempString = new StringBuffer(requestData).reverse().toString();
            }
            long value = StringUtil.signedCharArrayToLong(tempString.toCharArray());
            return new Float(Float.intBitsToFloat((int)value));
        }
        if (byteOrdering.equalsIgnoreCase("host")) {
            tempString = new StringBuffer(requestData).reverse().toString();
        }
        long value = StringUtil.signedCharArrayToLong(tempString.toCharArray());
        return new Double(Double.longBitsToDouble(value));
    }

    public Object unformatFloat(String requestData) throws LotteryException {
        return this.unformatFloat(requestData, 4, "pc");
    }

    public String formatDate(Date requestData, boolean useSeparator, String ordering, boolean isFourDigYear, String separator) throws LotteryException {
        if (separator == null || separator.trim().length() == 0) {
            separator = "/";
        }
        int intOrdering = 0;
        if (ordering.equalsIgnoreCase("mdy")) {
            intOrdering = 1;
        } else if (ordering.equalsIgnoreCase("ymd")) {
            intOrdering = 2;
        }
        SimpleDateFormat dateConverter = new SimpleDateFormat(this.getDatePattern(useSeparator, separator, isFourDigYear, intOrdering));
        return dateConverter.format(requestData);
    }

    public String formatDate(Date requestData) throws LotteryException {
        boolean useSeparator = true;
        String ordering = "dmy";
        boolean isFourDigYear = true;
        String separator = "/";
        return this.formatDate(requestData, useSeparator, ordering, isFourDigYear, separator);
    }

    public Date unformatDate(String requestData, boolean useSeparator, String ordering, boolean isFourDigYear, String separator) throws LotteryException {
        if (separator == null || separator.trim().length() == 0) {
            separator = "/";
        }
        int intOrdering = 0;
        if (ordering.equalsIgnoreCase("mdy")) {
            intOrdering = 1;
        } else if (ordering.equalsIgnoreCase("ymd")) {
            intOrdering = 2;
        }
        SimpleDateFormat dateConverter = new SimpleDateFormat(this.getDatePattern(useSeparator, separator, isFourDigYear, intOrdering));
        try {
            Date aDate = dateConverter.parse(requestData);
            return aDate;
        }
        catch (ParseException e) {
            String tempString = requestData;
            if (requestData.length() > 15) {
                tempString = String.valueOf(requestData.substring(0, 15)) + "...";
            }
            throw new LotteryException("Invalid Argument: " + requestData + "can not be parsed to a Date" + ". Format: " + requestData + ", Process: unformatField" + ", String: " + tempString);
        }
    }

    public Date unformatDate(String requestData) throws LotteryException {
        boolean useSeparator = true;
        String ordering = "dmy";
        boolean isFourDigYear = true;
        String separator = "/";
        return this.unformatDate(requestData, useSeparator, ordering, isFourDigYear, separator);
    }

    public String formatTime(Date requestData, boolean useSeparator, String hours, boolean isShowSeconds, String separator, String amString, String pmString) throws LotteryException {
        boolean hours24 = true;
        if (hours.equalsIgnoreCase("12")) {
            hours24 = false;
        }
        DateFormatSymbols dateSymbols = new DateFormatSymbols();
        String[] amPmStrings = new String[]{amString, pmString};
        dateSymbols.setAmPmStrings(amPmStrings);
        SimpleDateFormat dateConverter = new SimpleDateFormat(this.getTimePattern(useSeparator, separator, isShowSeconds, hours24), dateSymbols);
        return dateConverter.format(requestData);
    }

    public String formatTime(Date requestData) throws LotteryException {
        boolean useSeparator = true;
        String hours = "24";
        boolean isShowSeconds = true;
        String separator = "/";
        String amString = "am";
        String pmString = "pm";
        return this.formatTime(requestData, useSeparator, hours, isShowSeconds, separator, amString, pmString);
    }

    public Date unformatTime(String requestData, boolean useSeparator, String hours, boolean isShowSeconds, String separator, String amString, String pmString) throws LotteryException {
        boolean hours24 = true;
        if (hours.equalsIgnoreCase("12")) {
            hours24 = false;
        }
        DateFormatSymbols dateSymbols = new DateFormatSymbols();
        String[] amPmStrings = new String[]{amString, pmString};
        dateSymbols.setAmPmStrings(amPmStrings);
        SimpleDateFormat dateConverter = new SimpleDateFormat(this.getTimePattern(useSeparator, separator, isShowSeconds, hours24), dateSymbols);
        try {
            Date aTime = dateConverter.parse(requestData);
            return aTime;
        }
        catch (ParseException e) {
            throw new LotteryException("InvalidArgument: " + requestData + "can not be parsed" + ". Format: " + requestData + ", Process: unformatField");
        }
    }

    public Date unformatTime(String requestData) throws LotteryException {
        boolean useSeparator = true;
        String hours = "24";
        boolean isShowSeconds = true;
        String separator = "/";
        String amString = "am";
        String pmString = "pm";
        return this.unformatTime(requestData, useSeparator, hours, isShowSeconds, separator, amString, pmString);
    }

    public String addDelimiter(String requestData, String delimChar) throws LotteryException {
        String result = null;
        result = requestData != null ? String.valueOf(requestData) + delimChar : delimChar;
        return result;
    }

    public String removeDelimiter(String requestData, String delimiter) {
        String result = requestData;
        if (requestData != null && delimiter != null && requestData.endsWith(delimiter)) {
            result = requestData.substring(0, requestData.length() - 1);
        }
        return result;
    }

    public String addIdentifier(String requestData, char idChar) throws LotteryException {
        return String.valueOf(idChar) + requestData;
    }

    public String removeIdentifier(String requestData, char idChar) throws LotteryException {
        String aString = requestData;
        if (aString.length() <= 0 && aString.charAt(0) == idChar) {
            String messageException = "";
            messageException = aString.length() > 0 ? "Invalid Argument: wrong identifier" : "Invalid Argument: null string";
            String tempString = aString;
            if (aString.length() > 15) {
                tempString = String.valueOf(aString.substring(0, 15)) + "...";
            }
            throw new LotteryException(String.valueOf(messageException) + ". Format: " + requestData + ", Decorator: Identifier" + ", Process: removeDecoration" + ", String: " + tempString);
        }
        return aString.substring(1);
    }

    public String addCompressor(String requestData) throws LotteryException {
        int len;
        int DEFAULT_COMPRESSION = -1;
        int DEFAULT_BUFFER_SIZE = 512;
        int bufferSize = 512;
        if (requestData == null || requestData.length() == 0) {
            throw new LotteryException("InvalidArgument (addDecoration: " + requestData + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: addDecoration");
        }
        byte[] a = null;
        try {
            a = requestData.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (addDecoration: " + requestData + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: addDecoration");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(-1, true);
        byte[] buf = new byte[512];
        if (!def.finished()) {
            def.setInput(a, 0, a.length);
            while (!def.needsInput()) {
                len = def.deflate(buf, 0, buf.length);
                if (len <= 0) continue;
                baos.write(buf, 0, len);
            }
        }
        def.finish();
        while (!def.finished()) {
            len = def.deflate(buf, 0, buf.length);
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        def.reset();
        try {
            return baos.toString("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (addDecoration: " + requestData + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: addDecoration");
        }
    }

    public String removeCompressor(String requestData) throws LotteryException {
        String aString = requestData;
        int bufferSize = 512;
        try {
            byte[] buf = new byte[512];
            byte[] b = null;
            try {
                b = aString.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
            }
            byte[] c = new byte[100];
            int p = 0;
            String resString = new String();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            PushbackInputStream pbis = new PushbackInputStream(bais, bufferSize);
            Inflater inf = new Inflater(true);
            while ((p = this.read(c, 0, c.length, pbis, inf, buf)) != -1) {
                String readString = new String(c, 0, p, "UTF8");
                if (readString.equals("")) {
                    return this.removeCompressor(aString, 1000);
                }
                resString = String.valueOf(resString) + readString;
                c = new byte[100];
            }
            return resString;
        }
        catch (DataFormatException dfe) {
            throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
        }
    }

    public String removeCompressor(String requestData, int intArray) throws LotteryException {
        String aString = requestData;
        int bufferSize = 512;
        try {
            byte[] buf = new byte[512];
            byte[] b = null;
            try {
                b = aString.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
            }
            byte[] c = new byte[intArray];
            int p = 0;
            String resString = new String();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            PushbackInputStream pbis = new PushbackInputStream(bais, bufferSize);
            Inflater inf = new Inflater(true);
            while ((p = this.read(c, 0, c.length, pbis, inf, buf)) != -1) {
                String readString = new String(c, 0, p, "UTF8");
                if (readString.equals("")) {
                    return this.removeCompressor(aString, intArray * 10);
                }
                resString = String.valueOf(resString) + readString;
                c = new byte[intArray];
            }
            return resString;
        }
        catch (DataFormatException dfe) {
            throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: Compressor" + ", Process: removeDecoration");
        }
    }

    public String addFixDataLength(String requestData, int length, String justify, char padCharacter, boolean noEmpty) throws LotteryException {
        int intJustify = 0;
        if (justify.equalsIgnoreCase("right")) {
            intJustify = 1;
        } else if (justify.equalsIgnoreCase("center")) {
            intJustify = 2;
        }
        int rest = length - requestData.length();
        if (rest <= 0) {
            return requestData.substring(0, length);
        }
        StringBuffer padStringBuffer = new StringBuffer();
        int i = 0;
        while (i < rest) {
            padStringBuffer.append(padCharacter);
            ++i;
        }
        if (intJustify == 0) {
            padStringBuffer.insert(0, requestData);
            return padStringBuffer.toString();
        }
        if (intJustify == 1) {
            padStringBuffer.append(requestData);
            return padStringBuffer.toString();
        }
        padStringBuffer.insert(rest / 2, requestData);
        return padStringBuffer.toString();
    }

    public String removeFixDataLength(String requestData, int length, String justify, char padCharacter, boolean noEmpty) throws LotteryException {
        int index = -1;
        int lastIndex = 0;
        String aString = requestData;
        int intJustify = 0;
        if (justify.equalsIgnoreCase("right")) {
            intJustify = 1;
        } else if (justify.equalsIgnoreCase("center")) {
            intJustify = 2;
        }
        if (aString.length() != length) {
            String tempString = aString;
            if (aString.length() > 15) {
                tempString = String.valueOf(aString.substring(0, 15)) + "...";
            }
            throw new LotteryException("   InvalidArgument: String length incorrect. Format: " + requestData + ". Decorator: FixedLength" + ", Process: removeDecoration" + ", String: " + tempString);
        }
        int i = 0;
        while (i < aString.length() && index == -1) {
            if (aString.charAt(i) != padCharacter) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            if (noEmpty) {
                return String.valueOf(padCharacter);
            }
            return "";
        }
        if (intJustify == 1) {
            if (noEmpty && aString.substring(index).length() == 0) {
                return String.valueOf(padCharacter);
            }
            return aString.substring(index);
        }
        i = 0;
        while (i < aString.length()) {
            if (aString.charAt(i) != padCharacter) {
                lastIndex = i;
            }
            ++i;
        }
        if (intJustify == 0) {
            if (noEmpty && aString.substring(0, lastIndex + 1).length() == 0) {
                return String.valueOf(padCharacter);
            }
            return aString.substring(0, lastIndex + 1);
        }
        if (noEmpty && aString.substring(index, lastIndex + 1).length() == 0) {
            return String.valueOf(padCharacter);
        }
        return aString.substring(index, lastIndex + 1);
    }

    public String addMaximumLength(String requestData, int maxLength) throws LotteryException {
        String aString = requestData;
        if (aString.length() > maxLength) {
            return aString.substring(0, maxLength);
        }
        return aString;
    }

    public String addCodeSetTranslator(String requestData, String toCodeSet) throws LotteryException {
        String fromCodeSet = "8859_1";
        try {
            byte[] stringBytes = requestData.getBytes(toCodeSet);
            return new String(stringBytes, fromCodeSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (addDecoration: " + requestData + " (converter error)" + ". Format: " + requestData + ", Decorated: CodeSetTranslator" + ", Process: addDecoration");
        }
    }

    public String removeCodeSetTranslator(String requestData, String toCodeSet) throws LotteryException {
        String aString = requestData;
        String fromCodeSet = "8859_1";
        try {
            byte[] stringBytes = aString.getBytes(fromCodeSet);
            return new String(stringBytes, toCodeSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new LotteryException("InvalidArgument (removeDecoration: " + aString + " (converter error)" + ". Format: " + requestData + ", Decorator: CodeSetTranslator" + ", Process: removeDecoration");
        }
    }

    public Object addNullChecker(Object requestData) throws LotteryException {
        if (requestData == null) {
            return new String("");
        }
        return requestData;
    }

    private void setSignPolicy(DecimalFormat formatter, int usePositiveSign, int signRule) {
        String positiveSign = "";
        if (usePositiveSign == 2) {
            positiveSign = "+";
        }
        if (usePositiveSign == 3) {
            positiveSign = " ";
        }
        switch (signRule) {
            case 1: {
                formatter.setNegativePrefix("-");
                formatter.setPositivePrefix(positiveSign);
                formatter.setNegativeSuffix("");
                formatter.setPositiveSuffix("");
                break;
            }
            case 2: {
                formatter.setNegativePrefix("");
                formatter.setPositivePrefix("");
                formatter.setNegativeSuffix("-");
                formatter.setPositiveSuffix(positiveSign);
                break;
            }
            case 3: {
                formatter.setNegativePrefix("(");
                formatter.setPositivePrefix("");
                formatter.setNegativeSuffix(")");
                formatter.setPositiveSuffix("");
            }
        }
    }

    private String getDatePattern(boolean isUseSeparator, String separator, boolean isFourDigitYear, int ordering) {
        String pattern = "dd/MM/yy";
        String theSeparator = "";
        String theDigitYears = "yy";
        if (isUseSeparator) {
            theSeparator = separator;
        }
        if (isFourDigitYear) {
            theDigitYears = "yyyy";
        }
        switch (ordering) {
            case 0: {
                pattern = "dd" + theSeparator + "MM" + theSeparator + theDigitYears;
                break;
            }
            case 1: {
                pattern = "MM" + theSeparator + "dd" + theSeparator + theDigitYears;
                break;
            }
            case 2: {
                pattern = String.valueOf(theDigitYears) + theSeparator + "MM" + theSeparator + "dd";
            }
        }
        return pattern;
    }

    private String getTimePattern(boolean isUseSeparator, String separator, boolean isShowSeconds, boolean hours24) {
        String pattern = "hh:mm:ss";
        String theSeparator = "";
        String theSeconds = "";
        if (isUseSeparator) {
            theSeparator = separator;
        }
        if (isShowSeconds) {
            theSeconds = String.valueOf(theSeparator) + "ss";
        }
        pattern = hours24 ? "HH" + theSeparator + "mm" + theSeconds : "hh" + theSeparator + "mm" + theSeconds + "a";
        return pattern;
    }

    private int read(byte[] baf, int off, int len, InputStream in, Inflater inf, byte[] buf) throws DataFormatException {
        try {
            int n = 0;
            int lon = 0;
            while ((n = inf.inflate(baf, off, len)) == 0) {
                if (inf.finished() || inf.needsDictionary()) {
                    return -1;
                }
                if (!inf.needsInput()) continue;
                lon = in.read(buf, 0, buf.length);
                if (lon == -1) {
                    throw new EOFException("Unexpected EOF.... Format: " + in + ", Decorator: Compressor" + ", Process: read");
                }
                inf.setInput(buf, 0, lon);
            }
            return n;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }
}

