/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.invoker;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;

public class CMGDataSender {
    private static final int IS_STRING = 0;
    private static final int IS_INTEGER = 1;
    private static final int IS_LONG = 2;
    private static final int IS_BYTEARRAY = 3;
    private static final int IS_NULL = 4;
    protected String charEncoding;
    DataOutputStream outStream;
    DataInputStream inStream;
    Hashtable myDict = new Hashtable();

    public void beginReceive(DataInputStream in, int size) throws Exception {
        this.inStream = in;
        boolean atEnd = false;
        int number = 0;
        byte[] buffer = new byte[size];
        int current = 0;
        int total = 0;
        while (total < size) {
            current = in.read(buffer, total, size - total);
            if (current == -1) {
                String aMessage = "Receive Error";
                Exception e = new Exception(aMessage);
                throw e;
            }
            if (current > 0) {
                total += current;
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(buffer));
        number = this.inStream.readInt();
        try {
            int i = 0;
            while (i < number) {
                int intType;
                String name;
                try {
                    name = this.receiveString();
                    Integer type = this.receiveInteger();
                    intType = type;
                }
                catch (EOFException e) {
                    atEnd = true;
                    intType = 5;
                    name = "";
                }
                switch (intType) {
                    case 0: {
                        Object data = this.receiveString();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 1: {
                        Object data = this.receiveInteger();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 2: {
                        Object data = this.receiveLong();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 3: {
                        Object data = this.receiveBytes();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 4: {
                        Object data = this.receiveString();
                        this.myDict.put(name, "null");
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            this.inStream.reset();
            int tam = this.inStream.available();
            byte[] wrongResponse = new byte[tam];
            this.inStream.readFully(wrongResponse);
            throw new Exception(t.toString());
        }
    }

    public void beginReceive(DataInputStream in, int size, String charEncod) throws Exception {
        this.inStream = in;
        boolean atEnd = false;
        int number = 0;
        byte[] buffer = new byte[size];
        int current = 0;
        int total = 0;
        while (total < size) {
            current = in.read(buffer, total, size - total);
            if (current == -1) {
                String aMessage = "Recerve Error";
                Exception e = new Exception(aMessage);
                throw e;
            }
            if (current > 0) {
                total += current;
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(buffer));
        number = this.inStream.readInt();
        try {
            int i = 0;
            while (i < number) {
                int intType;
                String name;
                try {
                    name = this.receiveStringWithCharEncod(charEncod);
                    Integer type = this.receiveInteger();
                    intType = type;
                }
                catch (EOFException e) {
                    atEnd = true;
                    intType = 5;
                    name = "";
                }
                switch (intType) {
                    case 0: {
                        Object data = this.receiveStringWithCharEncod(charEncod);
                        this.myDict.put(name, data);
                        break;
                    }
                    case 1: {
                        Object data = this.receiveInteger();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 2: {
                        Object data = this.receiveLong();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 3: {
                        Object data = this.receiveBytes();
                        this.myDict.put(name, data);
                        break;
                    }
                    case 4: {
                        Object data = this.receiveStringWithCharEncod(charEncod);
                        this.myDict.put(name, "null");
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            this.inStream.reset();
            int tam = this.inStream.available();
            byte[] wrongResponse = new byte[tam];
            this.inStream.readFully(wrongResponse);
            throw new Exception(t.toString());
        }
    }

    public void beginSend(DataOutputStream out, int number) throws IOException {
        this.outStream = out;
    }

    public void endReceive() throws IOException {
        this.inStream.close();
    }

    public void endSend() throws IOException {
        this.outStream.close();
    }

    public byte[] getBytesUTF8(String aString) throws Exception {
        if (aString == null) {
            return null;
        }
        return aString.getBytes("UTF8");
    }

    private byte[] receiveBytes() throws IOException {
        int length = this.inStream.readInt();
        byte[] buffer = new byte[length];
        this.inStream.readFully(buffer);
        return buffer;
    }

    public byte[] receiveBytes(String name) throws IOException {
        Object data = this.myDict.get(name);
        if (data != "null") {
            byte[] buffer = (byte[])data;
            return buffer;
        }
        return null;
    }

    private Integer receiveInteger() throws IOException {
        Integer data = new Integer(this.inStream.readInt());
        return data;
    }

    public Integer receiveInteger(String name) throws IOException {
        Object data = this.myDict.get(name);
        if (data != "null") {
            return (Integer)data;
        }
        return null;
    }

    private Long receiveLong() throws IOException {
        Long data = new Long(this.inStream.readLong());
        return data;
    }

    public Long receiveLong(String name) throws IOException {
        Object data = this.myDict.get(name);
        if (data != "null") {
            return (Long)data;
        }
        return null;
    }

    private String receiveString() throws IOException {
        int length = this.inStream.readInt();
        byte[] buffer = new byte[length];
        this.inStream.readFully(buffer);
        String data = new String(buffer, "UTF8");
        return data;
    }

    public String receiveString(String name) throws IOException {
        Object data = this.myDict.get(name);
        if (data != "null") {
            return (String)data;
        }
        return null;
    }

    private void sendBytes(byte[] data) throws IOException {
        this.outStream.writeInt(data.length);
        this.outStream.write(data, 0, data.length);
    }

    public void sendBytes(byte[] name, byte[] data) throws Exception {
        if (data == null) {
            this.sendString(name, null);
        } else {
            this.sendString(name);
            this.sendInteger(new Integer(3));
            this.sendBytes(data);
        }
    }

    public void sendInteger(byte[] name, Integer data) throws Exception {
        if (data == null) {
            this.sendString(name, null);
        } else {
            this.sendString(name);
            this.sendInteger(new Integer(1));
            this.sendInteger(data);
        }
    }

    private void sendInteger(Integer data) throws IOException {
        this.outStream.writeInt(data);
    }

    public void sendLong(byte[] name, Long data) throws Exception {
        if (data == null) {
            this.sendString(name, null);
        } else {
            this.sendString(name);
            this.sendInteger(new Integer(2));
            this.sendLong(data);
        }
    }

    private void sendLong(Long data) throws IOException {
        this.outStream.writeLong(data);
    }

    private void sendString(byte[] data) throws IOException {
        this.outStream.write(data);
    }

    public void sendLHInt(int v) throws IOException {
        this.outStream.writeByte((byte)(v >>> 0 & 0xFF));
        this.outStream.writeByte((byte)(v >>> 8 & 0xFF));
        this.outStream.writeByte((byte)(v >>> 16 & 0xFF));
        this.outStream.writeByte((byte)(v >>> 24 & 0xFF));
    }

    public void sendString(byte[] name, byte[] data) throws Exception {
        this.sendString(name);
        if (data == null) {
            this.sendInteger(new Integer(4));
            this.sendString(this.getBytesUTF8("null"));
        } else {
            this.sendInteger(new Integer(0));
            this.sendString(data);
        }
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String c) {
        this.charEncoding = c;
    }

    public byte[] getBytes(String aString, String charEncod) throws Exception {
        if (aString == null) {
            return null;
        }
        return aString.getBytes(charEncod);
    }

    private String receiveStringWithCharEncod(String charEncod) throws IOException {
        int length = this.inStream.readInt();
        byte[] buffer = new byte[length];
        this.inStream.readFully(buffer);
        String data = new String(buffer, charEncod);
        return data;
    }

    public void sendString(byte[] name, byte[] data, String charEncod) throws Exception {
        this.sendString(name);
    }

    public void sendLong(byte[] name, Long data, String charEncod) throws Exception {
        if (data == null) {
            this.sendString(name, null, charEncod);
        } else {
            this.sendString(name);
            this.sendInteger(new Integer(2));
            this.sendLong(data);
        }
    }

    public void sendInteger(byte[] name, Integer data, String charEncod) throws Exception {
        if (data == null) {
            this.sendString(name, null, charEncod);
        } else {
            this.sendString(name);
            this.sendInteger(new Integer(1));
            this.sendInteger(data);
        }
    }
}

