/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.invoker;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class ContextFactory {
    private static final String NAMINGCONTEXTFACTORY = "org.jnp.interfaces.NamingContextFactory";
    private static final String INTERFACES = "org.jboss.naming:org.jnp.interfaces";

    private Context getRemoteContext(String url) throws Exception {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", NAMINGCONTEXTFACTORY);
            env.put("java.naming.provider.url", url);
            env.put("java.naming.factory.url.pkgs", INTERFACES);
            InitialContext initCtx = new InitialContext(env);
            return initCtx;
        }
        catch (NamingException e) {
            throw new Exception(e.getMessage());
        }
    }

    private Context getLocalContext(String url) throws Exception {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", NAMINGCONTEXTFACTORY);
            env.put("java.naming.provider.url", url);
            env.put("java.naming.factory.url.pkgs", INTERFACES);
            InitialContext initCtx = new InitialContext(env);
            return initCtx;
        }
        catch (NamingException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Object getBeanName(String beanName, String url) throws Exception {
        try {
            return this.getLocalContext(url).lookup(beanName);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public Object getBeanName(String beanName, Class clazz, String url) throws Exception {
        try {
            Object obj = this.getRemoteContext(url).lookup(beanName);
            return PortableRemoteObject.narrow((Object)obj, (Class)clazz);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

