/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.invoker;

import com.letousky.invoker.DataElement;
import com.letousky.invoker.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

public class KeyCollection
extends DataElement {
    protected Hashtable elements = new Hashtable(10, 1.0f);
    protected Hashtable nestedElements = null;
    int nextItem;
    protected Vector order = null;

    public KeyCollection() {
    }

    public KeyCollection(String aName) {
        this.setName(aName);
    }

    public void addElement(DataElement aDataElement) {
        if (!this.getElements().containsKey(aDataElement.getName())) {
            this.getOrderVector().insertElementAt(aDataElement.getName(), this.nextItem);
            ++this.nextItem;
        }
        this.getElements().put(aDataElement.getName(), aDataElement);
        this.nestedElements = null;
    }

    private void addElements(Hashtable theElements) {
        Enumeration theElementsKeys = theElements.keys();
        while (theElementsKeys.hasMoreElements()) {
            this.addElement((DataElement)theElements.get(theElementsKeys.nextElement()));
        }
    }

    public DataElement getElementAt(int index) {
        String aName = (String)this.getOrderVector().elementAt(index);
        if (aName == null) {
            return null;
        }
        if (aName.indexOf(".") != -1) {
            return (DataElement)this.getElements().get(aName);
        }
        DataElement retElem = this.tryGetElementAt(aName);
        if (retElem != null) {
            return this.getElementAt(aName);
        }
        return null;
    }

    public DataElement getElementAt(String aName) {
        DataElement de = null;
        de = this.tryGetElementAt(aName);
        if (de == null) {
            return null;
        }
        return de;
    }

    public Object getValueAt(String aName) {
        DataElement de = null;
        de = this.tryGetElementAt(aName);
        if (de == null) {
            return null;
        }
        return de.getValue();
    }

    public void setValue(String name, Object value) {
        DataElement de = null;
        de = this.tryGetElementAt(name);
        if (de != null) {
            de.setValue(value);
        } else {
            de = new DataElement();
            de.setName(name);
            de.setValue(value);
            this.getElements().put(name, de);
        }
    }

    public DataElement tryGetElementAt(String aName) {
        try {
            DataElement anElement = null;
            anElement = (DataElement)this.elements.get(aName);
            if (anElement != null) {
                return anElement;
            }
            int index = aName.indexOf(".");
            if (index > 0) {
                anElement = (DataElement)this.elements.get(aName.substring(0, index));
            }
            if (anElement != null) {
                return anElement.tryGetElementAt(aName.substring(index + 1));
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void removeAll() {
        this.getElements().clear();
        this.getOrderVector().removeAllElements();
        this.getNestedElements().clear();
        this.nestedElements = null;
        this.nextItem = 0;
    }

    public int size() {
        return this.getElements().size();
    }

    public Hashtable getElements() {
        return this.elements;
    }

    public void setElements(Hashtable elements) {
        this.elements = elements;
    }

    public Vector getOrderVector() {
        if (this.order == null) {
            this.order = new Vector(10, 10);
        }
        return this.order;
    }

    public Hashtable getNestedElements() {
        return this.nestedElements;
    }
}

