/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.util;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class ConvertUtil {
    public static final String[] SplitString(String szSource, String token) {
        if (szSource == null || token == null) {
            return null;
        }
        StringTokenizer st1 = new StringTokenizer(szSource, token);
        String[] d1 = new String[st1.countTokens()];
        int x = 0;
        while (x < d1.length) {
            if (st1.hasMoreTokens()) {
                d1[x] = st1.nextToken();
            }
            ++x;
        }
        return d1;
    }

    public static final String to_iso_8859_1(String source) {
        if (source == null) {
            return null;
        }
        try {
            String s = new String(source.getBytes("gb2312"), "iso-8859-1");
            return s;
        }
        catch (Exception uee) {
            String s1 = null;
            return s1;
        }
    }

    public static final String from_iso_8859_1(String source) {
        if (source == null) {
            return null;
        }
        try {
            String s = new String(source.getBytes("iso-8859-1"), "gb2312");
            return s;
        }
        catch (Exception uee) {
            String s1 = null;
            return s1;
        }
    }

    public static final String getNumberString(int i, int length) {
        String sret = String.valueOf(i);
        int lack = length - sret.length();
        if (lack == 0) {
            return sret;
        }
        if (lack > 0) {
            int x = 0;
            while (x < lack) {
                sret = "0" + sret;
                ++x;
            }
        } else {
            sret = sret.substring(0 - lack, sret.length());
        }
        return sret;
    }

    public static final String toFormInput(String oldValue) {
        if (oldValue == null) {
            return null;
        }
        String szTemp = "";
        int len = oldValue.length();
        int i = 0;
        while (i < len) {
            switch (oldValue.charAt(i)) {
                case '\"': {
                    szTemp = String.valueOf(szTemp) + "&quot;";
                    break;
                }
                default: {
                    szTemp = String.valueOf(szTemp) + oldValue.charAt(i);
                }
            }
            ++i;
        }
        return szTemp;
    }

    public static final String toPrice(double d) {
        DecimalFormat df = new DecimalFormat("#,##0.00");
        return df.format(d);
    }

    public static final String toPrice(float d) {
        DecimalFormat df = new DecimalFormat("##0.00");
        return df.format(d);
    }

    public static final String toPrice(String d) {
        DecimalFormat df = new DecimalFormat("#,##0.00");
        return df.format(Double.parseDouble(d));
    }

    public static final String toFormatedNum(double d, String model) {
        DecimalFormat df = new DecimalFormat(model);
        return df.format(d);
    }

    public static final String toShortPrice(String d) {
        DecimalFormat df = new DecimalFormat("##0.00");
        return df.format(Double.parseDouble(d));
    }

    public static final float toFloat(String value) {
        if (value == null) {
            return 0.0f;
        }
        String szTemp = "";
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) != ',') {
                szTemp = String.valueOf(szTemp) + value.charAt(i);
            }
            ++i;
        }
        try {
            float f = Float.parseFloat(szTemp);
            return f;
        }
        catch (NumberFormatException e) {
            float f1 = 0.0f;
            return f1;
        }
    }

    public static final double toDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        String szTemp = "";
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) != ',') {
                szTemp = String.valueOf(szTemp) + value.charAt(i);
            }
            ++i;
        }
        try {
            double d = Double.parseDouble(szTemp);
            return d;
        }
        catch (NumberFormatException e) {
            double d1 = 0.0;
            return d1;
        }
    }

    public static final long toLong(String value) {
        if (value == null) {
            return 0L;
        }
        String szTemp = "";
        int len = value.length();
        int i = 0;
        while (i < len) {
            if (value.charAt(i) != ',') {
                szTemp = String.valueOf(szTemp) + value.charAt(i);
            }
            ++i;
        }
        try {
            double dd = Double.parseDouble(szTemp);
            long l1 = (long)dd;
            return l1;
        }
        catch (NumberFormatException e) {
            long l = 0L;
            return l;
        }
    }

    public static final int toInt(String value) {
        return (int)ConvertUtil.toLong(value);
    }

    public static final String toIntStr(BigDecimal value) {
        return String.valueOf(value.intValue());
    }

    public static final Integer toInteger(String value) {
        return ConvertUtil.toInt(value);
    }

    public static BigDecimal toBigDecimal(String bigdecimal) {
        if (bigdecimal == null) {
            return null;
        }
        if (bigdecimal.trim().length() < 1) {
            return null;
        }
        try {
            return new BigDecimal(bigdecimal.trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static java.sql.Date toDate(String datetime) {
        String[] dt = ConvertUtil.SplitString(datetime, "-");
        if (dt == null || dt.length != 3) {
            return null;
        }
        int[] idt = new int[3];
        int i = 0;
        while (i < idt.length) {
            idt[i] = ConvertUtil.toInt(dt[i]);
            ++i;
        }
        Calendar c = Calendar.getInstance();
        c.set(idt[0], idt[1] - 1, idt[2]);
        return new java.sql.Date(c.getTime().getTime());
    }

    public static Timestamp toTimestamp(String datetime) {
        if (StringUtils.isEmpty(datetime)) {
            return null;
        }
        return Timestamp.valueOf(datetime);
    }

    public static final String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static final Integer toInteger(Object obj) {
        if (obj == null) {
            return Integer.valueOf("-1");
        }
        return Integer.valueOf(obj.toString());
    }

    public static final String replace(String s, String s1, String s2, int[] ai) {
        if (s == null) {
            return null;
        }
        int i = 0;
        if ((i = s.indexOf(s1, i)) >= 0) {
            int j = 0;
            ++j;
            char[] ac = s.toCharArray();
            char[] ac1 = s2.toCharArray();
            int k = s1.length();
            StringBuffer stringbuffer = new StringBuffer(ac.length);
            stringbuffer.append(ac, 0, i).append(ac1);
            int l = i += k;
            while ((i = s.indexOf(s1, i)) > 0) {
                ++j;
                stringbuffer.append(ac, l, i - l).append(ac1);
                l = i += k;
            }
            stringbuffer.append(ac, l, ac.length - l);
            ai[0] = j;
            return stringbuffer.toString();
        }
        return s;
    }

    public static final String replace(String s, String s1, String s2) {
        if (s == null) {
            return null;
        }
        int i = 0;
        if ((i = s.indexOf(s1, i)) >= 0) {
            char[] ac = s.toCharArray();
            char[] ac1 = s2.toCharArray();
            int j = s1.length();
            StringBuffer stringbuffer = new StringBuffer(ac.length);
            stringbuffer.append(ac, 0, i).append(ac1);
            int k = i += j;
            while ((i = s.indexOf(s1, i)) > 0) {
                stringbuffer.append(ac, k, i - k).append(ac1);
                k = i += j;
            }
            stringbuffer.append(ac, k, ac.length - k);
            return stringbuffer.toString();
        }
        return s;
    }

    public static final String replaceIgnoreCase(String s, String s1, String s2, int[] ai) {
        if (s == null) {
            return null;
        }
        String s3 = s.toLowerCase();
        String s4 = s1.toLowerCase();
        int i = 0;
        if ((i = s3.indexOf(s4, i)) >= 0) {
            int j = 0;
            char[] ac = s.toCharArray();
            char[] ac1 = s2.toCharArray();
            int k = s1.length();
            StringBuffer stringbuffer = new StringBuffer(ac.length);
            stringbuffer.append(ac, 0, i).append(ac1);
            int l = i += k;
            while ((i = s3.indexOf(s4, i)) > 0) {
                ++j;
                stringbuffer.append(ac, l, i - l).append(ac1);
                l = i += k;
            }
            stringbuffer.append(ac, l, ac.length - l);
            ai[0] = j;
            return stringbuffer.toString();
        }
        return s;
    }

    public static final String replaceIgnoreCase(String s, String s1, String s2) {
        if (s == null) {
            return null;
        }
        String s3 = s.toLowerCase();
        String s4 = s1.toLowerCase();
        int i = 0;
        if ((i = s3.indexOf(s4, i)) >= 0) {
            char[] ac = s.toCharArray();
            char[] ac1 = s2.toCharArray();
            int j = s1.length();
            StringBuffer stringbuffer = new StringBuffer(ac.length);
            stringbuffer.append(ac, 0, i).append(ac1);
            int k = i += j;
            while ((i = s3.indexOf(s4, i)) > 0) {
                stringbuffer.append(ac, k, i - k).append(ac1);
                k = i += j;
            }
            stringbuffer.append(ac, k, ac.length - k);
            return stringbuffer.toString();
        }
        return s;
    }

    public static final synchronized String hash(String s) {
        MessageDigest digest = null;
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nosuchalgorithmexception) {
                System.err.println("Failed to load the MD5 MessageDigest. system will be unable to function normally.");
                nosuchalgorithmexception.printStackTrace();
            }
        }
        digest.reset();
        digest.update(s.getBytes());
        return ConvertUtil.encodeHex(digest.digest());
    }

    public static final String encodeHex(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer(abyte0.length * 2);
        int i = 0;
        while (i < abyte0.length) {
            if ((abyte0[i] & 0xFF) < 16) {
                stringbuffer.append("0");
            }
            stringbuffer.append(Long.toString(abyte0[i] & 0xFF, 16));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static int compareCaseInsensitive(Object o1, Object o2) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 != (c2 = s2.charAt(i2)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                return c1 - c2;
            }
            ++i1;
            ++i2;
        }
        return n1 - n2;
    }

    public static int compareCaseSensitive(Object o1, Object o2) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 != (c2 = s2.charAt(i2))) {
                return c1 - c2;
            }
            ++i1;
            ++i2;
        }
        return n1 - n2;
    }

    public static void main(String[] args) {
    }

    public static final String chopAtWord(String string, int length) {
        if (string == null) {
            return string;
        }
        char[] charArray = string.toCharArray();
        int sLength = string.length();
        if (length < sLength) {
            sLength = length;
        }
        int i = 0;
        while (i < sLength - 1) {
            if (charArray[i] == '\r' && charArray[i + 1] == '\n') {
                return string.substring(0, i + 1);
            }
            if (charArray[i] == '\n') {
                return string.substring(0, i);
            }
            ++i;
        }
        if (charArray[sLength - 1] == '\n') {
            return string.substring(0, sLength - 1);
        }
        if (string.length() < length) {
            return string;
        }
        i = length - 1;
        while (i > 0) {
            if (charArray[i] == ' ') {
                return string.substring(0, i).trim();
            }
            --i;
        }
        return string.substring(0, length);
    }

    public static int monthOfDate(Date date) {
        int value = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        value = calendar.get(2) + 1;
        return value;
    }

    public static int yearOfDate(Date date) {
        int value = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        value = calendar.get(1);
        return value;
    }
}

