/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.ProbeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class ClassInfo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set SIMPLE_TYPE_SET = new HashSet();
    private static final Map CLASS_INFO_MAP = Collections.synchronizedMap(new HashMap());
    private String className;
    private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
    private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
    private HashMap setMethods = new HashMap();
    private HashMap getMethods = new HashMap();
    private HashMap setTypes = new HashMap();
    private HashMap getTypes = new HashMap();

    static {
        SIMPLE_TYPE_SET.add(String.class);
        SIMPLE_TYPE_SET.add(Byte.class);
        SIMPLE_TYPE_SET.add(Short.class);
        SIMPLE_TYPE_SET.add(Character.class);
        SIMPLE_TYPE_SET.add(Integer.class);
        SIMPLE_TYPE_SET.add(Long.class);
        SIMPLE_TYPE_SET.add(Float.class);
        SIMPLE_TYPE_SET.add(Double.class);
        SIMPLE_TYPE_SET.add(Boolean.class);
        SIMPLE_TYPE_SET.add(Date.class);
        SIMPLE_TYPE_SET.add(Class.class);
        SIMPLE_TYPE_SET.add(BigInteger.class);
        SIMPLE_TYPE_SET.add(BigDecimal.class);
        SIMPLE_TYPE_SET.add(Collection.class);
        SIMPLE_TYPE_SET.add(Set.class);
        SIMPLE_TYPE_SET.add(Map.class);
        SIMPLE_TYPE_SET.add(List.class);
        SIMPLE_TYPE_SET.add(HashMap.class);
        SIMPLE_TYPE_SET.add(TreeMap.class);
        SIMPLE_TYPE_SET.add(ArrayList.class);
        SIMPLE_TYPE_SET.add(LinkedList.class);
        SIMPLE_TYPE_SET.add(HashSet.class);
        SIMPLE_TYPE_SET.add(TreeSet.class);
        SIMPLE_TYPE_SET.add(Vector.class);
        SIMPLE_TYPE_SET.add(Hashtable.class);
        SIMPLE_TYPE_SET.add(Enumeration.class);
    }

    private ClassInfo(Class clazz) {
        this.className = clazz.getName();
        this.addMethods(clazz);
        Class superClass = clazz.getSuperclass();
        while (superClass != null) {
            this.addMethods(superClass);
            superClass = superClass.getSuperclass();
        }
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
    }

    private void addMethods(Class cls) {
        Method[] methods = cls.getMethods();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (name.startsWith("set") && name.length() > 3) {
                if (methods[i].getParameterTypes().length == 1) {
                    name = ClassInfo.dropCase(name);
                    this.setMethods.put(name, methods[i]);
                    this.setTypes.put(name, methods[i].getParameterTypes()[0]);
                }
            } else if (name.startsWith("get") && name.length() > 3) {
                if (methods[i].getParameterTypes().length == 0) {
                    name = ClassInfo.dropCase(name);
                    this.getMethods.put(name, methods[i]);
                    this.getTypes.put(name, methods[i].getReturnType());
                }
            } else if (name.startsWith("is") && name.length() > 2 && methods[i].getParameterTypes().length == 0) {
                name = ClassInfo.dropCase(name);
                this.getMethods.put(name, methods[i]);
                this.getTypes.put(name, methods[i].getReturnType());
            }
            name = null;
            ++i;
        }
    }

    private static String dropCase(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new ProbeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = String.valueOf(name.substring(0, 1).toLowerCase(Locale.US)) + name.substring(1);
        }
        return name;
    }

    public String getClassName() {
        return this.className;
    }

    public Method getSetter(String propertyName) {
        Method method = (Method)this.setMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Method getGetter(String propertyName) {
        Method method = (Method)this.getMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Class getSetterType(String propertyName) {
        Class clazz = (Class)this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public Class getGetterType(String propertyName) {
        Class clazz = (Class)this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public String[] getReadablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getWriteablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasWritableProperty(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasReadableProperty(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public static boolean isKnownType(Class clazz) {
        if (SIMPLE_TYPE_SET.contains(clazz)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Iterator.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo getInstance(Class clazz) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            ClassInfo cache = (ClassInfo)CLASS_INFO_MAP.get(clazz);
            if (cache == null) {
                cache = new ClassInfo(clazz);
                CLASS_INFO_MAP.put(clazz, cache);
            }
            return cache;
        }
    }

    public static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                t2 = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof UndeclaredThrowableException)) break;
            t2 = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        return t2;
    }
}

