/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.exception.NestedRuntimeException;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class C3P0Configuration {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String ADD_DRIVER_PROPS_PREFIX = "Driver.";
    private static final int ADD_DRIVER_PROPS_PREFIX_LENGTH = "Driver.".length();
    private DataSource dataSource;

    public C3P0Configuration(Map properties) {
        try {
            this.dataSource = this.legacyC3P0Configuration(properties);
            if (this.dataSource == null) {
                this.dataSource = this.newDbcpConfiguration(properties);
            }
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error initializing C3P0DataSourceFactory.  Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private BasicDataSource newDbcpConfiguration(Map map) {
        BasicDataSource basicDataSource = new BasicDataSource();
        for (String propertyName : map.keySet()) {
            String value;
            if (propertyName.startsWith(ADD_DRIVER_PROPS_PREFIX)) {
                value = (String)map.get(propertyName);
                basicDataSource.addConnectionProperty(propertyName.substring(ADD_DRIVER_PROPS_PREFIX_LENGTH), value);
                continue;
            }
            if (!PROBE.hasWritableProperty(basicDataSource, propertyName)) continue;
            value = (String)map.get(propertyName);
            Object convertedValue = this.convertValue(basicDataSource, propertyName, value);
            PROBE.setObject(basicDataSource, propertyName, convertedValue);
        }
        return basicDataSource;
    }

    private Object convertValue(Object object, String propertyName, String value) {
        Object convertedValue = value;
        Class targetType = PROBE.getPropertyTypeForSetter(object, propertyName);
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            convertedValue = Integer.valueOf(value);
        } else if (targetType == Long.class || targetType == Long.TYPE) {
            convertedValue = Long.valueOf(value);
        } else if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            convertedValue = Boolean.valueOf(value);
        }
        return convertedValue;
    }

    private ComboPooledDataSource legacyC3P0Configuration(Map map) throws Exception {
        ComboPooledDataSource basicDataSource = null;
        if (map.containsKey("driver")) {
            basicDataSource = new ComboPooledDataSource();
            String driver = (String)map.get("driver");
            String url = (String)map.get("url");
            String username = (String)map.get("username");
            String password = (String)map.get("password");
            String initialPoolSize = (String)map.get("initialPoolSize");
            String maxPoolSize = (String)map.get("maxPoolSize");
            String minPoolSize = (String)map.get("minPoolSize");
            String acquireIncrement = (String)map.get("acquireIncrement");
            String maxIdleTime = (String)map.get("maxIdleTime");
            String maxIdleTimeExcessConnections = (String)map.get("maxIdleTimeExcessConnections");
            String maxConnectionAge = (String)map.get("maxConnectionAge");
            String maxStatements = (String)map.get("maxStatements");
            String maxStatementsPerConnection = (String)map.get("maxStatementsPerConnection");
            String numHelperThreads = (String)map.get("numHelperThreads");
            basicDataSource.setDriverClass(driver);
            basicDataSource.setJdbcUrl(url);
            basicDataSource.setUser(username);
            basicDataSource.setPassword(password);
            if (this.notEmpty(initialPoolSize)) {
                basicDataSource.setInitialPoolSize(Integer.parseInt(initialPoolSize));
            }
            if (this.notEmpty(maxPoolSize)) {
                basicDataSource.setMaxPoolSize(Integer.parseInt(maxPoolSize));
            }
            if (this.notEmpty(minPoolSize)) {
                basicDataSource.setMinPoolSize(Integer.parseInt(minPoolSize));
            }
            if (this.notEmpty(acquireIncrement)) {
                basicDataSource.setAcquireIncrement(Integer.parseInt(acquireIncrement));
            }
            if (this.notEmpty(maxIdleTime)) {
                basicDataSource.setMaxIdleTime(Integer.parseInt(maxIdleTime));
            }
            if (this.notEmpty(maxIdleTimeExcessConnections)) {
                basicDataSource.setMaxIdleTimeExcessConnections(Integer.parseInt(maxIdleTimeExcessConnections));
            }
            if (this.notEmpty(maxConnectionAge)) {
                basicDataSource.setMaxConnectionAge(Integer.parseInt(maxConnectionAge));
            }
            if (this.notEmpty(maxStatements)) {
                basicDataSource.setMaxStatements(Integer.parseInt(maxStatements));
            }
            if (this.notEmpty(maxStatementsPerConnection)) {
                basicDataSource.setMaxStatementsPerConnection(Integer.parseInt(maxStatementsPerConnection));
            }
            if (this.notEmpty(numHelperThreads)) {
                basicDataSource.setNumHelperThreads(Integer.parseInt(numHelperThreads));
            }
        }
        return basicDataSource;
    }

    private boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }
}

