/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.resources.Resources;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class ScriptRunner {
    private String driver;
    private String url;
    private String username;
    private String password;
    private boolean stopOnError;
    private boolean autoCommit;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);

    public ScriptRunner() {
        this.stopOnError = false;
        this.autoCommit = false;
    }

    public ScriptRunner(Map props) {
        this.setDriver((String)props.get("driver"));
        this.setUrl((String)props.get("url"));
        this.setUsername((String)props.get("username"));
        this.setPassword((String)props.get("password"));
        this.setStopOnError("true".equals(props.get("stopOnError")));
        this.setAutoCommit("true".equals(props.get("autoCommit")));
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public PrintWriter getErrorLogWriter() {
        return this.errorLogWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void runScript(Reader reader) throws ClassNotFoundException, SQLException, IOException, IllegalAccessException, InstantiationException {
        DriverManager.registerDriver((Driver)Resources.classForName(this.driver).newInstance());
        Connection conn = DriverManager.getConnection(this.url, this.username, this.password);
        if (conn.getAutoCommit() != this.autoCommit) {
            conn.setAutoCommit(this.autoCommit);
        }
        this.runScript(conn, reader);
        conn.close();
    }

    public void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            try {
                LineNumberReader lineReader = new LineNumberReader(reader);
                String line = null;
                while ((line = lineReader.readLine()) != null) {
                    String trimmedLine;
                    if (command == null) {
                        command = new StringBuffer();
                    }
                    if ((trimmedLine = line.trim()).startsWith("--")) {
                        this.println(trimmedLine);
                        continue;
                    }
                    if (trimmedLine.length() < 1 || trimmedLine.startsWith("//")) continue;
                    if (trimmedLine.endsWith(";")) {
                        command.append(line.substring(0, line.lastIndexOf(";")));
                        command.append(" ");
                        Statement statement = conn.createStatement();
                        this.println(command);
                        boolean hasResults = false;
                        if (this.stopOnError) {
                            hasResults = statement.execute(command.toString());
                        } else {
                            try {
                                statement.execute(command.toString());
                            }
                            catch (SQLException e) {
                                e.fillInStackTrace();
                                this.printlnError("Error executing: " + command);
                                this.printlnError(e);
                            }
                        }
                        if (this.autoCommit && !conn.getAutoCommit()) {
                            conn.commit();
                        }
                        ResultSet rs = statement.getResultSet();
                        if (hasResults && rs != null) {
                            ResultSetMetaData md = rs.getMetaData();
                            int cols = md.getColumnCount();
                            int i = 0;
                            while (i < cols) {
                                String name = md.getColumnName(i);
                                this.print(String.valueOf(name) + "\t");
                                ++i;
                            }
                            this.println("");
                            while (rs.next()) {
                                i = 0;
                                while (i < cols) {
                                    String value = rs.getString(i);
                                    this.print(String.valueOf(value) + "\t");
                                    ++i;
                                }
                                this.println("");
                            }
                        }
                        command = null;
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Thread.yield();
                        continue;
                    }
                    command.append(line);
                    command.append(" ");
                }
                if (!this.autoCommit) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
            catch (IOException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
        }
        finally {
            conn.rollback();
            this.flush();
        }
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            System.out.print(o);
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

