/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.ResultSetLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class PreparedStatementLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(PreparedStatement.class);
    private PreparedStatement statement;
    private String sql;

    private PreparedStatementLogProxy(PreparedStatement stmt, String sql) {
        this.statement = stmt;
        this.sql = sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("{pstm-" + this.id + "} PreparedStatement: " + this.removeBreakingWhitespace(this.sql));
                    log.debug("{pstm-" + this.id + "} Parameters: " + this.getValueString());
                    log.debug("{pstm-" + this.id + "} Types: " + this.getTypeString());
                }
                this.clearColumnInfo();
                if (!"executeQuery".equals(method.getName())) return method.invoke((Object)this.statement, params);
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs == null) return null;
                return ResultSetLogProxy.newInstance(rs);
            }
            if (!SET_METHODS.contains(method.getName())) {
                if (!"getResultSet".equals(method.getName())) return method.invoke((Object)this.statement, params);
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs == null) return null;
                return ResultSetLogProxy.newInstance(rs);
            }
            if ("setNull".equals(method.getName())) {
                this.setColumn(params[0], null);
                return method.invoke((Object)this.statement, params);
            }
            this.setColumn(params[0], params[1]);
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static PreparedStatement newInstance(PreparedStatement stmt, String sql) {
        PreparedStatementLogProxy handler = new PreparedStatementLogProxy(stmt, sql);
        ClassLoader cl = PreparedStatement.class.getClassLoader();
        return (PreparedStatement)Proxy.newProxyInstance(cl, new Class[]{PreparedStatement.class, CallableStatement.class}, (InvocationHandler)handler);
    }
}

