/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.ResultSetLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;

public class StatementLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(Statement.class);
    private Statement statement;

    private StatementLogProxy(Statement stmt) {
        this.statement = stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("{stmt-" + this.id + "} Statement: " + this.removeBreakingWhitespace((String)params[0]));
                }
                if (!"executeQuery".equals(method.getName())) {
                    return method.invoke((Object)this.statement, params);
                }
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogProxy.newInstance(rs);
                }
                return null;
            }
            if (!"getResultSet".equals(method.getName())) {
                return method.invoke((Object)this.statement, params);
            }
            ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
            if (rs != null) {
                return ResultSetLogProxy.newInstance(rs);
            }
            return null;
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static Statement newInstance(Statement stmt) {
        StatementLogProxy handler = new StatementLogProxy(stmt);
        ClassLoader cl = Statement.class.getClassLoader();
        return (Statement)Proxy.newProxyInstance(cl, new Class[]{Statement.class}, (InvocationHandler)handler);
    }
}

