/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.exception.NestedRuntimeException;

public class Throttle {
    private final Object LOCK = new Object();
    private int count;
    private int limit;
    private long maxWait;

    public Throttle(int limit) {
        this.limit = limit;
        this.maxWait = 0L;
    }

    public Throttle(int limit, long maxWait) {
        this.limit = limit;
        this.maxWait = maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.count >= this.limit) {
                if (this.maxWait > 0L) {
                    long waitTime = System.currentTimeMillis();
                    try {
                        this.LOCK.wait(this.maxWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    waitTime = System.currentTimeMillis() - waitTime;
                    if (waitTime > this.maxWait) {
                        throw new NestedRuntimeException("Throttle waited too long (" + waitTime + ") for lock.");
                    }
                } else {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.count;
            this.LOCK.notify();
        }
    }
}

