/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.xml;

import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeletUtils {
    public static boolean getBooleanAttribute(Properties attribs, String name, boolean def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return "true".equals(value);
    }

    public static int getIntAttribute(Properties attribs, String name, int def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public static Properties parseAttributes(Node n) {
        return NodeletUtils.parseAttributes(n, null);
    }

    public static Properties parseAttributes(Node n, Properties variables) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        int i = 0;
        while (i < attributeNodes.getLength()) {
            Node attribute = attributeNodes.item(i);
            String value = NodeletUtils.parsePropertyTokens(attribute.getNodeValue(), variables);
            attributes.put(attribute.getNodeName(), value);
            ++i;
        }
        return attributes;
    }

    public static String parsePropertyTokens(String string, Properties variables) {
        String OPEN = "${";
        String CLOSE = "}";
        String newString = string;
        if (newString != null && variables != null) {
            int start = newString.indexOf("${");
            int end = newString.indexOf("}");
            while (start > -1 && end > start) {
                String prepend = newString.substring(0, start);
                String append = newString.substring(end + "}".length());
                String propName = newString.substring(start + "${".length(), end);
                String propValue = variables.getProperty(propName);
                newString = propValue == null ? String.valueOf(prepend) + propName + append : String.valueOf(prepend) + propValue + append;
                start = newString.indexOf("${");
                end = newString.indexOf("}");
            }
        }
        return newString;
    }
}

