/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.impl;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.dao.client.Dao;
import com.ibatis.dao.engine.impl.DaoContext;
import com.ibatis.dao.engine.impl.DaoImpl;
import com.ibatis.dao.engine.impl.StandardDaoManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public class DaoProxy
implements InvocationHandler {
    private static final Set PASSTHROUGH_METHODS = new HashSet();
    private DaoImpl daoImpl;

    static {
        PASSTHROUGH_METHODS.add("equals");
        PASSTHROUGH_METHODS.add("getClass");
        PASSTHROUGH_METHODS.add("hashCode");
        PASSTHROUGH_METHODS.add("notify");
        PASSTHROUGH_METHODS.add("notifyAll");
        PASSTHROUGH_METHODS.add("toString");
        PASSTHROUGH_METHODS.add("wait");
    }

    public DaoProxy(DaoImpl daoImpl) {
        this.daoImpl = daoImpl;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (PASSTHROUGH_METHODS.contains(method.getName())) {
            try {
                result = method.invoke((Object)this.daoImpl.getDaoInstance(), args);
            }
            catch (Throwable t) {
                throw ClassInfo.unwrapThrowable(t);
            }
        }
        StandardDaoManager daoManager = this.daoImpl.getDaoManager();
        DaoContext context = this.daoImpl.getDaoContext();
        if (daoManager.isExplicitTransaction()) {
            try {
                context.startTransaction();
                result = method.invoke((Object)this.daoImpl.getDaoInstance(), args);
            }
            catch (Throwable t) {
                throw ClassInfo.unwrapThrowable(t);
            }
        }
        try {
            try {
                context.startTransaction();
                result = method.invoke((Object)this.daoImpl.getDaoInstance(), args);
                context.commitTransaction();
            }
            catch (Throwable t) {
                throw ClassInfo.unwrapThrowable(t);
            }
        }
        finally {
            context.endTransaction();
        }
        return result;
    }

    public static Dao newInstance(DaoImpl daoImpl) {
        return (Dao)Proxy.newProxyInstance(daoImpl.getDaoInterface().getClassLoader(), new Class[]{Dao.class, daoImpl.getDaoInterface()}, (InvocationHandler)new DaoProxy(daoImpl));
    }
}

