/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.jdbc;

import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.engine.transaction.ConnectionDaoTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JdbcDaoTransaction
implements ConnectionDaoTransaction {
    private static final Log connectionLog = LogFactory.getLog(Connection.class);
    private Connection connection;

    public JdbcDaoTransaction(DataSource dataSource) {
        try {
            this.connection = dataSource.getConnection();
            if (this.connection == null) {
                throw new DaoException("Could not start transaction.  Cause: The DataSource returned a null connection.");
            }
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
            if (connectionLog.isDebugEnabled()) {
                this.connection = ConnectionLogProxy.newInstance(this.connection);
            }
        }
        catch (SQLException e) {
            throw new DaoException("Error starting JDBC transaction.  Cause: " + e);
        }
    }

    public void commit() {
        try {
            try {
                this.connection.commit();
            }
            finally {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new DaoException("Error committing JDBC transaction.  Cause: " + e);
        }
    }

    public void rollback() {
        try {
            try {
                this.connection.rollback();
            }
            finally {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new DaoException("Error ending JDBC transaction.  Cause: " + e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

