/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.jdbc;

import com.ibatis.common.jdbc.C3P0Configuration;
import com.ibatis.common.jdbc.DbcpConfiguration;
import com.ibatis.common.jdbc.SimpleDataSource;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoTransaction;
import com.ibatis.dao.engine.transaction.DaoTransactionManager;
import com.ibatis.dao.engine.transaction.jdbc.JdbcDaoTransaction;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JdbcDaoTransactionManager
implements DaoTransactionManager {
    private DataSource dataSource;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Properties properties) {
        if (!properties.containsKey("DataSource")) throw new DaoException("DAO Transaction Manager properties must include a value for 'DataSource' of SIMPLE, DBCP or JNDI.");
        String type = (String)properties.get("DataSource");
        if ("SIMPLE".equals(type)) {
            this.configureSimpleDataSource(properties);
            return;
        } else if ("DBCP".equals(type)) {
            this.configureDbcp(properties);
            return;
        } else if ("JNDI".equals(type)) {
            this.configureJndi(properties);
            return;
        } else {
            if (!"C3P0".equals(type)) throw new DaoException("DAO Transaction Manager properties must include a value for 'DataSource' of SIMPLE, DBCP or JNDI.");
            this.configureC3p0(properties);
        }
    }

    public DaoTransaction startTransaction() {
        return new JdbcDaoTransaction(this.dataSource);
    }

    private void configureSimpleDataSource(Map properties) {
        this.dataSource = new SimpleDataSource(properties);
    }

    private void configureDbcp(Map properties) {
        DbcpConfiguration dbcp = new DbcpConfiguration(properties);
        this.dataSource = dbcp.getDataSource();
    }

    private void configureC3p0(Map properties) {
        C3P0Configuration c3p0 = new C3P0Configuration(properties);
        this.dataSource = c3p0.getDataSource();
    }

    private void configureJndi(Map properties) {
        try {
            Hashtable contextProps = JdbcDaoTransactionManager.getContextProperties(properties);
            InitialContext initCtx = null;
            initCtx = contextProps == null ? new InitialContext() : new InitialContext(contextProps);
            this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DBJndiContext"));
        }
        catch (NamingException e) {
            throw new DaoException("There was an error configuring the DataSource from JNDI.  Cause: " + e, e);
        }
    }

    public void commitTransaction(DaoTransaction trans) {
        ((JdbcDaoTransaction)trans).commit();
    }

    public void rollbackTransaction(DaoTransaction trans) {
        ((JdbcDaoTransaction)trans).rollback();
    }

    private static Hashtable getContextProperties(Map allProps) {
        String PREFIX = "context.";
        Properties contextProperties = null;
        for (String key : allProps.keySet()) {
            String value = (String)allProps.get(key);
            if (!key.startsWith("context.")) continue;
            if (contextProperties == null) {
                contextProperties = new Properties();
            }
            ((Hashtable)contextProperties).put(key.substring("context.".length()), value);
        }
        return contextProperties;
    }
}

