/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.jta;

import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.engine.transaction.ConnectionDaoTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class JtaDaoTransaction
implements ConnectionDaoTransaction {
    private static final Log connectionLog = LogFactory.getLog(Connection.class);
    private UserTransaction userTransaction;
    private DataSource dataSource;
    private Connection connection;
    private boolean commmitted = false;
    private boolean newTransaction = false;

    public JtaDaoTransaction(UserTransaction utx, DataSource ds) {
        this.userTransaction = utx;
        this.dataSource = ds;
        if (this.userTransaction == null) {
            throw new DaoException("JtaTransaction initialization failed.  UserTransaction was null.");
        }
        if (this.dataSource == null) {
            throw new DaoException("JtaTransaction initialization failed.  DataSource was null.");
        }
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new DaoException("JtaTransaction could not start transaction.  Cause: ", e);
        }
        try {
            this.connection = this.dataSource.getConnection();
            if (this.connection == null) {
                throw new DaoException("Could not start transaction.  Cause: The DataSource returned a null connection.");
            }
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
            if (connectionLog.isDebugEnabled()) {
                this.connection = ConnectionLogProxy.newInstance(this.connection);
            }
        }
        catch (SQLException e) {
            throw new DaoException("Error opening JDBC connection.  Cause: " + e, e);
        }
    }

    public void commit() {
        if (this.commmitted) {
            throw new DaoException("JtaTransaction could not commit because this transaction has already been committed.");
        }
        try {
            try {
                if (this.newTransaction) {
                    this.userTransaction.commit();
                }
            }
            finally {
                this.close();
            }
        }
        catch (Exception e) {
            throw new DaoException("JtaTransaction could not commit.  Cause: ", e);
        }
        this.commmitted = true;
    }

    public void rollback() {
        if (!this.commmitted) {
            try {
                try {
                    if (this.userTransaction != null) {
                        if (this.newTransaction) {
                            this.userTransaction.rollback();
                        } else {
                            this.userTransaction.setRollbackOnly();
                        }
                    }
                }
                finally {
                    this.close();
                }
            }
            catch (Exception e) {
                throw new DaoException("JTA transaction could not rollback.  Cause: ", e);
            }
        }
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

