/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.jta;

import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoTransaction;
import com.ibatis.dao.engine.transaction.DaoTransactionManager;
import com.ibatis.dao.engine.transaction.jta.JtaDaoTransaction;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class JtaDaoTransactionManager
implements DaoTransactionManager {
    private DataSource dataSource;
    private UserTransaction userTransaction;

    public void configure(Properties properties) {
        String utxName = null;
        String dsName = null;
        try {
            utxName = (String)properties.get("UserTransaction");
            InitialContext initCtx = new InitialContext();
            this.userTransaction = (UserTransaction)initCtx.lookup(utxName);
            dsName = (String)properties.get("DBJndiContext");
            this.dataSource = (DataSource)initCtx.lookup(dsName);
        }
        catch (Exception e) {
            throw new DaoException("Error initializing JTA transaction while looking up UserTransaction (" + utxName + ") or DataSource (" + dsName + ").  Cause: " + e);
        }
    }

    public DaoTransaction startTransaction() {
        return new JtaDaoTransaction(this.userTransaction, this.dataSource);
    }

    public void commitTransaction(DaoTransaction trans) {
        ((JtaDaoTransaction)trans).commit();
    }

    public void rollbackTransaction(DaoTransaction trans) {
        ((JtaDaoTransaction)trans).rollback();
    }
}

