/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao.jdbc;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import com.ibatis.db.dao.jdbc.SqlMap2DaoTransaction;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;

public class SqlMap2DaoTransactionPool
implements DaoTransactionPool {
    private SqlMapClient sqlMap;

    public void configure(Map properties) throws DaoException {
        try {
            String xmlConfig = (String)properties.get("sql-map-config-file");
            Reader reader = Resources.getResourceAsReader(xmlConfig);
            this.sqlMap = SqlMapClientBuilder.buildSqlMapClient(reader);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error configuring SqlMapClientDaoTransactionPool.  Cause: " + e, e);
        }
    }

    public DaoTransaction getTransaction() throws DaoException {
        try {
            this.sqlMap.startTransaction();
            return new SqlMap2DaoTransaction(this.sqlMap);
        }
        catch (SQLException e) {
            throw new DaoException("Error getting transaction. Cause: " + e, (Throwable)e);
        }
    }

    public void releaseTransaction(DaoTransaction trans) throws DaoException {
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMap;
    }
}

