/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.db.sqlmap.RowHandler;
import com.ibatis.db.sqlmap.RowHandlerAdapter;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class MappedStatement {
    private SqlMapClient sqlMapClient;
    private String statementName;

    public MappedStatement(SqlMapClient sqlMapClient, String statementName) {
        this.sqlMapClient = sqlMapClient;
        this.statementName = statementName;
    }

    public int executeUpdate(Connection conn, Object parameterObject) throws SQLException {
        int n;
        try {
            this.sqlMapClient.setUserConnection(conn);
            n = this.sqlMapClient.update(this.statementName, parameterObject);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return n;
    }

    public void executeQueryWithRowHandler(Connection conn, Object parameterObject, RowHandler rowHandler) throws SQLException {
        try {
            this.sqlMapClient.setUserConnection(conn);
            this.sqlMapClient.queryWithRowHandler(this.statementName, parameterObject, new RowHandlerAdapter(rowHandler));
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
    }

    public Map executeQueryForMap(Connection conn, Object parameterObject, String keyProperty) throws SQLException {
        Map map;
        try {
            this.sqlMapClient.setUserConnection(conn);
            map = this.sqlMapClient.queryForMap(this.statementName, parameterObject, keyProperty);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return map;
    }

    public Map executeQueryForMap(Connection conn, Object parameterObject, String keyProperty, String valueProperty) throws SQLException {
        Map map;
        try {
            this.sqlMapClient.setUserConnection(conn);
            map = this.sqlMapClient.queryForMap(this.statementName, parameterObject, keyProperty, valueProperty);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return map;
    }

    public PaginatedList executeQueryForPaginatedList(Object parameterObject, int pageSize) throws SQLException {
        PaginatedList list = this.sqlMapClient.queryForPaginatedList(this.statementName, parameterObject, pageSize);
        return list;
    }

    public List executeQueryForList(Connection conn, Object parameterObject) throws SQLException {
        List list;
        try {
            this.sqlMapClient.setUserConnection(conn);
            list = this.sqlMapClient.queryForList(this.statementName, parameterObject);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return list;
    }

    public List executeQueryForList(Connection conn, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        List list;
        try {
            this.sqlMapClient.setUserConnection(conn);
            list = this.sqlMapClient.queryForList(this.statementName, parameterObject, skipResults, maxResults);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return list;
    }

    public Object executeQueryForObject(Connection conn, Object parameterObject) throws SQLException {
        Object o;
        try {
            this.sqlMapClient.setUserConnection(conn);
            o = this.sqlMapClient.queryForObject(this.statementName, parameterObject);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return o;
    }

    public Object executeQueryForObject(Connection conn, Object parameterObject, Object resultObject) throws SQLException {
        Object o;
        try {
            this.sqlMapClient.setUserConnection(conn);
            o = this.sqlMapClient.queryForObject(this.statementName, parameterObject, resultObject);
        }
        finally {
            this.sqlMapClient.setUserConnection(null);
        }
        return o;
    }
}

