/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.RowHandler;
import com.ibatis.db.sqlmap.RowHandlerAdapter;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMap {
    private SqlMapClient client;

    public SqlMap(SqlMapClient client) {
        this.client = client;
    }

    public MappedStatement getMappedStatement(String name) {
        return new MappedStatement(this.client, name);
    }

    public void startTransaction() throws SQLException {
        this.client.startTransaction();
    }

    public void commitTransaction() throws SQLException {
        this.client.commitTransaction();
        this.client.endTransaction();
    }

    public void rollbackTransaction() throws SQLException {
        this.client.endTransaction();
    }

    public int executeUpdate(String statementName, Object parameterObject) throws SQLException {
        return this.client.update(statementName, parameterObject);
    }

    public Object executeQueryForObject(String statementName, Object parameterObject) throws SQLException {
        return this.client.queryForObject(statementName, parameterObject);
    }

    public Object executeQueryForObject(String statementName, Object parameterObject, Object resultObject) throws SQLException {
        return this.client.queryForObject(statementName, parameterObject, resultObject);
    }

    public Map executeQueryForMap(String statementName, Object parameterObject, String keyProperty) throws SQLException {
        return this.client.queryForMap(statementName, parameterObject, keyProperty);
    }

    public Map executeQueryForMap(String statementName, Object parameterObject, String keyProperty, String valueProperty) throws SQLException {
        return this.client.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
    }

    public List executeQueryForList(String statementName, Object parameterObject) throws SQLException {
        return this.client.queryForList(statementName, parameterObject);
    }

    public List executeQueryForList(String statementName, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        return this.client.queryForList(statementName, parameterObject, skipResults, maxResults);
    }

    public PaginatedList executeQueryForPaginatedList(String statementName, Object parameterObject, int pageSize) throws SQLException {
        return this.client.queryForPaginatedList(statementName, parameterObject, pageSize);
    }

    public void executeQueryWithRowHandler(String statementName, Object parameterObject, RowHandler rowHandler) throws SQLException {
        this.client.queryWithRowHandler(statementName, parameterObject, new RowHandlerAdapter(rowHandler));
    }

    public void startBatch() throws SQLException {
        this.client.startBatch();
    }

    public void endBatch() throws SQLException {
        this.client.executeBatch();
    }

    public DataSource getDataSource() {
        return this.client.getDataSource();
    }
}

