/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.upgrade;

import com.ibatis.db.sqlmap.upgrade.SqlMapXmlConverter;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class ConvertTask
extends Copy {
    private static final SqlMapXmlConverter CONVERTER = new SqlMapXmlConverter();

    protected void doFileOperations() {
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String toFile;
                String fromFile = (String)e.nextElement();
                if (fromFile.equals(toFile = (String)this.fileCopyMap.get(fromFile))) {
                    this.log("Skipping self-copy of " + fromFile, this.verbosity);
                    continue;
                }
                try {
                    this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                    FilterSetCollection executionFilters = new FilterSetCollection();
                    if (this.filtering) {
                        executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                    }
                    Enumeration filterEnum = this.getFilterSets().elements();
                    while (filterEnum.hasMoreElements()) {
                        executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                    }
                    File temp = File.createTempFile("sql-map-", "-temp");
                    CONVERTER.convertFile(new File(fromFile), temp);
                    this.getFileUtils().copyFile(temp, new File(toFile), executionFilters, this.getFilterChains(), this.forceOverwrite, this.preserveLastModified, this.getEncoding(), this.getProject());
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    File targetFile = new File(toFile);
                    if (targetFile.exists() && !targetFile.delete()) {
                        msg = String.valueOf(msg) + " and I couldn't delete the corrupt " + toFile;
                    }
                    throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                File d = new File((String)e.nextElement());
                if (d.exists()) continue;
                if (!d.mkdirs()) {
                    this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.log("Copied " + count + " empty director" + (count == 1 ? "y" : "ies") + " to " + this.destDir.getAbsolutePath());
            }
        }
    }
}

