/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.upgrade;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.db.sqlmap.upgrade.DocTypeReader;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.XmlConverter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SqlMapXmlConverter
implements XmlConverter {
    public void convertXml(Reader reader, Writer writer) {
        try {
            DocTypeReader xml = new DocTypeReader(reader);
            String docType = xml.getDocType();
            Reader xsl = null;
            if (docType == null) {
                throw new SqlMapException("Could not convert document because DOCTYPE was null.");
            }
            if (docType.indexOf("sql-map-config") > -1) {
                xsl = Resources.getResourceAsReader("com/ibatis/db/sqlmap/upgrade/SqlMapConfig.xsl");
            } else if (docType.indexOf("sql-map") > -1) {
                xsl = Resources.getResourceAsReader("com/ibatis/db/sqlmap/upgrade/SqlMap.xsl");
            } else {
                throw new SqlMapException("Could not convert document because DOCTYPE was not recognized: " + docType);
            }
            this.transformXml(xsl, xml, writer);
        }
        catch (IOException e) {
            throw new NestedRuntimeException("Error.  Cause: " + e, e);
        }
        catch (TransformerException e) {
            throw new NestedRuntimeException("Error.  Cause: " + e, e);
        }
    }

    public Reader convertXml(Reader reader) {
        StringWriter out = new StringWriter();
        this.convertXml(reader, out);
        return new StringReader(out.getBuffer().toString());
    }

    public void convertFile(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        this.convertFile(fromFile, toFile);
    }

    public void convertFile(File fromFile, File toFile) throws IOException {
        FileReader reader = new FileReader(fromFile);
        FileWriter writer = new FileWriter(toFile);
        this.convertXml(reader, writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        ((Reader)reader).close();
    }

    protected void transformXml(Reader xslReader, Reader xmlReader, Writer xmlWriter) throws TransformerException {
        StreamSource xslSource = new StreamSource(xslReader);
        StreamSource xmlSource = new StreamSource(xmlReader);
        StreamResult xmlResult = new StreamResult(xmlWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(xslSource);
        transformer.setParameter("http://xml.org/sax/features/validation", new Boolean(false));
        transformer.setParameter("http://apache.org/xml/features/nonvalidating/load-dtd", new Boolean(false));
        transformer.transform(xmlSource, xmlResult);
    }
}

