/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.accessplan;

import com.ibatis.sqlmap.engine.accessplan.AccessPlan;
import com.ibatis.sqlmap.engine.accessplan.BaseAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.ComplexAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.EnhancedPropertyAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.MapAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.PropertyAccessPlan;
import java.util.Map;

public class AccessPlanFactory {
    private static boolean bytecodeEnhancementEnabled = false;

    private AccessPlanFactory() {
    }

    public static AccessPlan getAccessPlan(Class clazz, String[] propertyNames) {
        BaseAccessPlan plan;
        boolean complex = false;
        if (clazz == null || propertyNames == null) {
            complex = true;
        } else {
            int i = 0;
            while (i < propertyNames.length) {
                if (propertyNames[i].indexOf(91) > -1 || propertyNames[i].indexOf(46) > -1) {
                    complex = true;
                    break;
                }
                ++i;
            }
        }
        if (complex) {
            plan = new ComplexAccessPlan(clazz, propertyNames);
        } else if (Map.class.isAssignableFrom(clazz)) {
            plan = new MapAccessPlan(clazz, propertyNames);
        } else if (bytecodeEnhancementEnabled) {
            try {
                plan = new EnhancedPropertyAccessPlan(clazz, propertyNames);
            }
            catch (Throwable t) {
                try {
                    plan = new PropertyAccessPlan(clazz, propertyNames);
                }
                catch (Throwable t2) {
                    plan = new ComplexAccessPlan(clazz, propertyNames);
                }
            }
        } else {
            try {
                plan = new PropertyAccessPlan(clazz, propertyNames);
            }
            catch (Throwable t) {
                plan = new ComplexAccessPlan(clazz, propertyNames);
            }
        }
        return plan;
    }

    public static boolean isBytecodeEnhancementEnabled() {
        return bytecodeEnhancementEnabled;
    }

    public static void setBytecodeEnhancementEnabled(boolean bytecodeEnhancementEnabled) {
        AccessPlanFactory.bytecodeEnhancementEnabled = bytecodeEnhancementEnabled;
    }
}

