/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.accessplan;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.engine.accessplan.BaseAccessPlan;
import java.lang.reflect.Method;

public class PropertyAccessPlan
extends BaseAccessPlan {
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected Method[] setters;
    protected Method[] getters;

    PropertyAccessPlan(Class clazz, String[] propertyNames) {
        super(clazz, propertyNames);
        this.setters = this.getSetters(propertyNames);
        this.getters = this.getGetters(propertyNames);
    }

    public void setProperties(Object object, Object[] values) {
        try {
            Object[] arg = new Object[1];
            int i = 0;
            while (i < this.propertyNames.length) {
                arg[0] = values[i];
                try {
                    this.setters[i].invoke(object, arg);
                }
                catch (Throwable t) {
                    throw ClassInfo.unwrapThrowable(t);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new NestedRuntimeException("Error setting properties of '" + object + "'.  Cause: " + t, t);
        }
    }

    public Object[] getProperties(Object object) {
        Object[] values = new Object[this.propertyNames.length];
        try {
            int i = 0;
            while (i < this.propertyNames.length) {
                try {
                    values[i] = this.getters[i].invoke(object, NO_ARGUMENTS);
                }
                catch (Throwable t) {
                    throw ClassInfo.unwrapThrowable(t);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new NestedRuntimeException("Error getting properties of '" + object + "'.  Cause: " + t, t);
        }
        return values;
    }
}

