/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.BaseParser;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandlerFactory;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.stat.StaticSql;
import com.ibatis.sqlmap.engine.mapping.statement.CachingStatement;
import com.ibatis.sqlmap.engine.mapping.statement.GeneralStatement;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlStatementParser
extends BaseParser {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();

    public SqlStatementParser(BaseParser.Variables vars) {
        super(vars);
    }

    /*
     * Unable to fully structure code
     */
    public MappedStatement parseGeneralStatement(Node node, GeneralStatement statement) {
        this.vars.errorCtx.setActivity("parsing a mapped statement");
        attributes = NodeletUtils.parseAttributes(node, this.vars.currentProperties);
        id = attributes.getProperty("id");
        if (this.vars.useStatementNamespaces) {
            id = this.applyNamespace(id);
        }
        parameterMapName = this.applyNamespace(attributes.getProperty("parameterMap"));
        parameterClassName = attributes.getProperty("parameterClass");
        resultMapName = this.applyNamespace(attributes.getProperty("resultMap"));
        resultClassName = attributes.getProperty("resultClass");
        cacheModelName = this.applyNamespace(attributes.getProperty("cacheModel"));
        xmlResultName = attributes.getProperty("xmlResultName");
        resultSetType = attributes.getProperty("resultSetType");
        fetchSize = attributes.getProperty("fetchSize");
        allowRemapping = attributes.getProperty("remapResults");
        this.vars.errorCtx.setObjectId(String.valueOf(id) + " statement");
        parameterClassName = this.vars.typeHandlerFactory.resolveAlias(parameterClassName);
        resultClassName = this.vars.typeHandlerFactory.resolveAlias(resultClassName);
        parameterClass = null;
        resultClass = null;
        this.vars.errorCtx.setMoreInfo("Check the result map name.");
        resultMap = null;
        if (resultMapName != null) {
            resultMap = (BasicResultMap)this.vars.client.getDelegate().getResultMap(resultMapName);
        }
        this.vars.errorCtx.setMoreInfo("Check the parameter map name.");
        parameterMap = null;
        if (parameterMapName != null) {
            parameterMap = (BasicParameterMap)this.vars.client.getDelegate().getParameterMap(parameterMapName);
        }
        statement.setId(id);
        statement.setParameterMap(parameterMap);
        statement.setResultMap(resultMap);
        statement.setResource(this.vars.errorCtx.getResource());
        if (resultSetType != null) {
            if ("FORWARD_ONLY".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1003));
            } else if ("SCROLL_INSENSITIVE".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1004));
            } else if ("SCROLL_SENSITIVE".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1005));
            }
        }
        if (fetchSize != null) {
            statement.setFetchSize(new Integer(fetchSize));
        }
        if (parameterMap == null) {
            try {
                if (parameterClassName == null) ** GOTO lbl53
                this.vars.errorCtx.setMoreInfo("Check the parameter class.");
                parameterClass = Resources.classForName(parameterClassName);
                statement.setParameterClass(parameterClass);
            }
            catch (ClassNotFoundException e) {
                throw new SqlMapException("Error.  Could not set parameter class.  Cause: " + e, e);
            }
        } else {
            statement.setParameterClass(parameterMap.getParameterClass());
        }
lbl53:
        // 3 sources

        try {
            if (resultClassName != null) {
                this.vars.errorCtx.setMoreInfo("Check the result class.");
                resultClass = Resources.classForName(resultClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not set result class.  Cause: " + e, e);
        }
        this.vars.errorCtx.setMoreInfo("Check the SQL statement.");
        this.processSqlStatement(node, statement);
        if (resultMap == null && resultClass == null) {
            statement.setResultMap(null);
        } else if (resultMap == null) {
            resultMap = new AutoResultMap(this.vars.client.getDelegate(), "true".equals(allowRemapping));
            resultMap.setId(String.valueOf(statement.getId()) + "-AutoResultMap");
            resultMap.setResultClass(resultClass);
            resultMap.setXmlName(xmlResultName);
            resultMap.setResource(statement.getResource());
            statement.setResultMap(resultMap);
        }
        this.vars.errorCtx.setMoreInfo(null);
        this.vars.errorCtx.setObjectId(null);
        statement.setSqlMapClient(this.vars.client);
        if (cacheModelName != null && cacheModelName.length() > 0 && this.vars.client.getDelegate().isCacheModelsEnabled()) {
            cacheModel = this.vars.client.getDelegate().getCacheModel(cacheModelName);
            return new CachingStatement(statement, cacheModel);
        }
        return statement;
    }

    private void processSqlStatement(Node n, GeneralStatement statement) {
        this.vars.errorCtx.setActivity("processing an SQL statement");
        boolean isDynamic = false;
        DynamicSql dynamic = new DynamicSql(this.vars.client.getDelegate());
        StringBuffer sqlBuffer = new StringBuffer();
        isDynamic = this.parseDynamicTags(n, dynamic, sqlBuffer, isDynamic, false);
        if (statement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)statement;
            SelectKeyStatement selectKeyStatement = this.findAndParseSelectKeyStatement(n, statement);
            insertStatement.setSelectKeyStatement(selectKeyStatement);
        }
        String sqlStatement = sqlBuffer.toString();
        if (isDynamic) {
            statement.setSql(dynamic);
        } else {
            this.applyInlineParameterMap(statement, sqlStatement);
        }
    }

    private boolean parseDynamicTags(Node node, DynamicParent dynamic, StringBuffer sqlBuffer, boolean isDynamic, boolean postParseRequired) {
        this.vars.errorCtx.setActivity("parsing dynamic SQL tags");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                SqlText sqlText;
                String data = ((CharacterData)child).getData();
                data = NodeletUtils.parsePropertyTokens(data, this.vars.properties);
                if (postParseRequired) {
                    sqlText = new SqlText();
                    sqlText.setPostParseRequired(postParseRequired);
                    sqlText.setText(data.toString());
                } else {
                    sqlText = PARAM_PARSER.parseInlineParameterMap(this.vars.client.getDelegate().getTypeHandlerFactory(), data.toString(), null);
                    sqlText.setPostParseRequired(postParseRequired);
                }
                dynamic.addChild(sqlText);
                sqlBuffer.append(data);
            } else if ("include".equals(nodeName)) {
                String nsrefid;
                Properties attributes = NodeletUtils.parseAttributes(child, this.vars.properties);
                String refid = (String)attributes.get("refid");
                Node includeNode = (Node)this.vars.sqlIncludes.get(refid);
                if (includeNode == null && (includeNode = (Node)this.vars.sqlIncludes.get(nsrefid = this.applyNamespace(refid))) == null) {
                    throw new NestedRuntimeException("Could not find SQL statement to include with refid '" + refid + "'");
                }
                isDynamic = this.parseDynamicTags(includeNode, dynamic, sqlBuffer, isDynamic, false);
            } else {
                this.vars.errorCtx.setMoreInfo("Check the dynamic tags.");
                SqlTagHandler handler = SqlTagHandlerFactory.getSqlTagHandler(nodeName);
                if (handler != null) {
                    isDynamic = true;
                    SqlTag tag = new SqlTag();
                    tag.setName(nodeName);
                    tag.setHandler(handler);
                    Properties attributes = NodeletUtils.parseAttributes(child, this.vars.properties);
                    tag.setPrependAttr(attributes.getProperty("prepend"));
                    tag.setPropertyAttr(attributes.getProperty("property"));
                    tag.setRemoveFirstPrepend(attributes.getProperty("removeFirstPrepend"));
                    tag.setOpenAttr(attributes.getProperty("open"));
                    tag.setCloseAttr(attributes.getProperty("close"));
                    tag.setComparePropertyAttr(attributes.getProperty("compareProperty"));
                    tag.setCompareValueAttr(attributes.getProperty("compareValue"));
                    tag.setConjunctionAttr(attributes.getProperty("conjunction"));
                    if (dynamic instanceof SqlTag) {
                        SqlTag parentSqlTag = (SqlTag)dynamic;
                        if (parentSqlTag.isPostParseRequired() || tag.getHandler() instanceof IterateTagHandler) {
                            tag.setPostParseRequired(true);
                        }
                    } else if (dynamic instanceof DynamicSql && tag.getHandler() instanceof IterateTagHandler) {
                        tag.setPostParseRequired(true);
                    }
                    dynamic.addChild(tag);
                    if (child.hasChildNodes()) {
                        isDynamic = this.parseDynamicTags(child, tag, sqlBuffer, isDynamic, tag.isPostParseRequired());
                    }
                }
            }
            ++i;
        }
        this.vars.errorCtx.setMoreInfo(null);
        return isDynamic;
    }

    private SelectKeyStatement findAndParseSelectKeyStatement(Node n, GeneralStatement insertStatement) {
        this.vars.errorCtx.setActivity("parsing select key tags");
        SelectKeyStatement selectKeyStatement = null;
        boolean foundTextFirst = false;
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                String data = ((CharacterData)child).getData();
                if (data.trim().length() > 0) {
                    foundTextFirst = true;
                }
            } else if (child.getNodeType() == 1 && "selectKey".equals(child.getNodeName())) {
                selectKeyStatement = this.parseSelectKey(child, insertStatement);
                break;
            }
            ++i;
        }
        if (selectKeyStatement != null) {
            selectKeyStatement.setAfter(foundTextFirst);
        }
        this.vars.errorCtx.setMoreInfo(null);
        return selectKeyStatement;
    }

    private SelectKeyStatement parseSelectKey(Node node, GeneralStatement insertStatement) {
        this.vars.errorCtx.setActivity("parsing a select key");
        Properties attributes = NodeletUtils.parseAttributes(node, this.vars.properties);
        String keyPropName = attributes.getProperty("keyProperty");
        String resultClassName = attributes.getProperty("resultClass");
        resultClassName = this.vars.typeHandlerFactory.resolveAlias(resultClassName);
        Class resultClass = null;
        SelectKeyStatement selectKeyStatement = new SelectKeyStatement();
        selectKeyStatement.setSqlMapClient(this.vars.client);
        selectKeyStatement.setId(String.valueOf(insertStatement.getId()) + "-SelectKey");
        selectKeyStatement.setResource(this.vars.errorCtx.getResource());
        selectKeyStatement.setKeyProperty(keyPropName);
        try {
            if (resultClassName != null) {
                this.vars.errorCtx.setMoreInfo("Check the select key result class.");
                resultClass = Resources.classForName(resultClassName);
            } else {
                Class parameterClass = insertStatement.getParameterClass();
                if (keyPropName != null && parameterClass != null) {
                    resultClass = PROBE.getPropertyTypeForSetter(parameterClass, selectKeyStatement.getKeyProperty());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not set result class.  Cause: " + e, e);
        }
        if (resultClass == null) {
            resultClass = Object.class;
        }
        this.vars.errorCtx.setMoreInfo("Check the select key SQL statement.");
        this.processSqlStatement(node, selectKeyStatement);
        AutoResultMap resultMap = new AutoResultMap(this.vars.client.getDelegate(), false);
        resultMap.setId(String.valueOf(selectKeyStatement.getId()) + "-AutoResultMap");
        resultMap.setResultClass(resultClass);
        resultMap.setResource(selectKeyStatement.getResource());
        selectKeyStatement.setResultMap(resultMap);
        this.vars.errorCtx.setMoreInfo(null);
        return selectKeyStatement;
    }

    private void applyInlineParameterMap(GeneralStatement statement, String sqlStatement) {
        String newSql = sqlStatement;
        this.vars.errorCtx.setActivity("building an inline parameter map");
        ParameterMap parameterMap = statement.getParameterMap();
        this.vars.errorCtx.setMoreInfo("Check the inline parameters.");
        if (parameterMap == null) {
            BasicParameterMap map = new BasicParameterMap(this.vars.client.getDelegate());
            map.setId(String.valueOf(statement.getId()) + "-InlineParameterMap");
            map.setParameterClass(statement.getParameterClass());
            map.setResource(statement.getResource());
            statement.setParameterMap(map);
            SqlText sqlText = PARAM_PARSER.parseInlineParameterMap(this.vars.client.getDelegate().getTypeHandlerFactory(), newSql, statement.getParameterClass());
            newSql = sqlText.getText();
            List<ParameterMapping> mappingList = Arrays.asList(sqlText.getParameterMappings());
            map.setParameterMappingList(mappingList);
        }
        Sql sql = null;
        sql = SimpleDynamicSql.isSimpleDynamicSql(newSql) ? new SimpleDynamicSql(this.vars.client.getDelegate(), newSql) : new StaticSql(newSql);
        statement.setSql(sql);
    }
}

