/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.exchange;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.exchange.BaseDataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.Map;

public class ComplexDataExchange
extends BaseDataExchange
implements DataExchange {
    private static final Probe PROBE = ProbeFactory.getProbe();

    public ComplexDataExchange(DataExchangeFactory dataExchangeFactory) {
        super(dataExchangeFactory);
    }

    public void initialize(Map properties) {
    }

    public Object[] getData(RequestScope request, ParameterMap parameterMap, Object parameterObject) {
        TypeHandlerFactory typeHandlerFactory = this.getDataExchangeFactory().getTypeHandlerFactory();
        if (parameterObject == null) {
            return new Object[1];
        }
        if (typeHandlerFactory.hasTypeHandler(parameterObject.getClass())) {
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            Object[] data = new Object[mappings.length];
            int i = 0;
            while (i < mappings.length) {
                data[i] = parameterObject;
                ++i;
            }
            return data;
        }
        Object[] data = new Object[parameterMap.getParameterMappings().length];
        ParameterMapping[] mappings = parameterMap.getParameterMappings();
        int i = 0;
        while (i < mappings.length) {
            data[i] = PROBE.getObject(parameterObject, mappings[i].getPropertyName());
            ++i;
        }
        return data;
    }

    public Object setData(RequestScope request, ResultMap resultMap, Object resultObject, Object[] values) {
        TypeHandlerFactory typeHandlerFactory = this.getDataExchangeFactory().getTypeHandlerFactory();
        if (typeHandlerFactory.hasTypeHandler(resultMap.getResultClass())) {
            return values[0];
        }
        Object object = resultObject;
        if (object == null) {
            try {
                object = Resources.instantiate(resultMap.getResultClass());
            }
            catch (Exception e) {
                throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate result class.  Cause: " + e, e);
            }
        }
        ResultMapping[] mappings = resultMap.getResultMappings();
        int i = 0;
        while (i < mappings.length) {
            PROBE.setObject(object, mappings[i].getPropertyName(), values[i]);
            ++i;
        }
        return object;
    }

    public Object setData(RequestScope request, ParameterMap parameterMap, Object parameterObject, Object[] values) {
        TypeHandlerFactory typeHandlerFactory = this.getDataExchangeFactory().getTypeHandlerFactory();
        if (typeHandlerFactory.hasTypeHandler(parameterMap.getParameterClass())) {
            return values[0];
        }
        Object object = parameterObject;
        if (object == null) {
            try {
                object = Resources.instantiate(parameterMap.getParameterClass());
            }
            catch (Exception e) {
                throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate result class.  Cause: " + e, e);
            }
        }
        ParameterMapping[] mappings = parameterMap.getParameterMappings();
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].isOutputAllowed()) {
                PROBE.setObject(object, mappings[i].getPropertyName(), values[i]);
            }
            ++i;
        }
        return object;
    }
}

