/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.exchange;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.accessplan.AccessPlan;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.exchange.BaseDataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.util.ArrayList;
import java.util.Map;

public class JavaBeanDataExchange
extends BaseDataExchange
implements DataExchange {
    private static final Object[] NO_DATA = new Object[0];
    private AccessPlan resultPlan;
    private AccessPlan parameterPlan;
    private AccessPlan outParamPlan;

    protected JavaBeanDataExchange(DataExchangeFactory dataExchangeFactory) {
        super(dataExchangeFactory);
    }

    public void initialize(Map properties) {
        ResultMap resultMap;
        Object map = properties.get("map");
        if (map instanceof ParameterMap) {
            ParameterMap parameterMap = (ParameterMap)map;
            if (parameterMap != null) {
                ParameterMapping[] parameterMappings = parameterMap.getParameterMappings();
                String[] parameterPropNames = new String[parameterMappings.length];
                int i = 0;
                while (i < parameterPropNames.length) {
                    parameterPropNames[i] = parameterMappings[i].getPropertyName();
                    ++i;
                }
                this.parameterPlan = AccessPlanFactory.getAccessPlan(parameterMap.getParameterClass(), parameterPropNames);
                ArrayList<String> outParamList = new ArrayList<String>();
                int i2 = 0;
                while (i2 < parameterPropNames.length) {
                    if (parameterMappings[i2].isOutputAllowed()) {
                        outParamList.add(parameterMappings[i2].getPropertyName());
                    }
                    ++i2;
                }
                String[] outParams = outParamList.toArray(new String[outParamList.size()]);
                this.outParamPlan = AccessPlanFactory.getAccessPlan(parameterMap.getParameterClass(), outParams);
            }
        } else if (map instanceof ResultMap && (resultMap = (ResultMap)map) != null) {
            ResultMapping[] resultMappings = resultMap.getResultMappings();
            String[] resultPropNames = new String[resultMappings.length];
            int i = 0;
            while (i < resultPropNames.length) {
                resultPropNames[i] = resultMappings[i].getPropertyName();
                ++i;
            }
            this.resultPlan = AccessPlanFactory.getAccessPlan(resultMap.getResultClass(), resultPropNames);
        }
    }

    public Object[] getData(RequestScope request, ParameterMap parameterMap, Object parameterObject) {
        if (this.parameterPlan != null) {
            return this.parameterPlan.getProperties(parameterObject);
        }
        return NO_DATA;
    }

    public Object setData(RequestScope request, ResultMap resultMap, Object resultObject, Object[] values) {
        if (this.resultPlan != null) {
            Object object = resultObject;
            ErrorContext errorContext = request.getErrorContext();
            if (object == null) {
                errorContext.setMoreInfo("The error occured while instantiating the result object");
                try {
                    object = Resources.instantiate(resultMap.getResultClass());
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate result class.  Cause: " + e, e);
                }
            }
            errorContext.setMoreInfo("The error happened while setting a property on the result object.");
            this.resultPlan.setProperties(object, values);
            return object;
        }
        return null;
    }

    public Object setData(RequestScope request, ParameterMap parameterMap, Object parameterObject, Object[] values) {
        if (this.outParamPlan != null) {
            Object object = parameterObject;
            if (object == null) {
                try {
                    object = Resources.instantiate(parameterMap.getParameterClass());
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate parameter class. Cause: " + e, e);
                }
            }
            values = this.getOutputParamValues(parameterMap.getParameterMappings(), values);
            this.outParamPlan.setProperties(object, values);
            return object;
        }
        return null;
    }

    private Object[] getOutputParamValues(ParameterMapping[] mappings, Object[] values) {
        ArrayList<Object> outParamValues = new ArrayList<Object>();
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].isOutputAllowed()) {
                outParamValues.add(values[i]);
            }
            ++i;
        }
        return outParamValues.toArray();
    }
}

