/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutor {
    public static final int NO_SKIPPED_RESULTS = 0;
    public static final int NO_MAXIMUM_RESULTS = -999999;

    public int executeUpdate(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = conn.prepareStatement(sql);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            rows = ps.getUpdateCount();
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(ps);
            throw throwable;
        }
        SqlExecutor.closeStatement(ps);
        return rows;
    }

    public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        Batch batch = (Batch)request.getSession().getBatch();
        if (batch == null) {
            batch = new Batch();
            request.getSession().setBatch(batch);
        }
        batch.addBatch(request, conn, sql, parameters);
    }

    public int executeBatch(SessionScope session) throws SQLException {
        int rows = 0;
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            try {
                rows = batch.executeBatch();
            }
            finally {
                batch.cleanupBatch();
            }
        }
        return rows;
    }

    public void executeQuery(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = request.getStatement().getResultSetType();
            ps = rsType != null ? conn.prepareStatement(sql, rsType, 1007) : conn.prepareStatement(sql);
            Integer fetchSize = request.getStatement().getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (query failed).");
            ps.execute();
            rs = ps.getResultSet();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            this.handleResults(request, rs, skipResults, maxResults, callback);
            while (ps.getMoreResults()) {
            }
        }
        catch (Throwable throwable) {
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(ps);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(ps);
        }
    }

    public int executeUpdateProcedure(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = conn.prepareCall(sql);
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rows = cs.getUpdateCount();
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(cs, mappings, parameters);
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(cs);
            throw throwable;
        }
        SqlExecutor.closeStatement(cs);
        return rows;
    }

    public void executeQueryProcedure(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = conn.prepareCall(sql);
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rs = cs.getResultSet();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            this.handleResults(request, rs, skipResults, maxResults, callback);
            while (cs.getMoreResults()) {
            }
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(cs, mappings, parameters);
        }
        catch (Throwable throwable) {
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(cs);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(cs);
        }
    }

    public void cleanup(SessionScope session) {
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            batch.cleanupBatch();
            session.setBatch(null);
        }
    }

    private void retrieveOutputParameters(CallableStatement cs, ParameterMapping[] mappings, Object[] parameters) throws SQLException {
        int i = 0;
        while (i < mappings.length) {
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (mapping.isOutputAllowed()) {
                Object o;
                parameters[i] = o = mapping.getTypeHandler().getResult(cs, i + 1);
            }
            ++i;
        }
    }

    private void registerOutputParameters(CallableStatement cs, ParameterMapping[] mappings) throws SQLException {
        int i = 0;
        while (i < mappings.length) {
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (mapping.isOutputAllowed()) {
                if (mapping.getTypeName() != null && !mapping.getTypeName().equals("")) {
                    cs.registerOutParameter(i + 1, mapping.getJdbcType(), mapping.getTypeName());
                } else {
                    cs.registerOutParameter(i + 1, mapping.getJdbcType());
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleResults(RequestScope request, ResultSet rs, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        try {
            request.setResultSet(rs);
            resultMap = request.getResultMap();
            if (resultMap == null) return;
            if (rs.getType() != 1003) {
                if (skipResults > 0) {
                    rs.absolute(skipResults);
                }
            } else {
                i = 0;
                while (i < skipResults) {
                    if (!rs.next()) break;
                    ++i;
                }
            }
            resultsFetched = 0;
            if (true) ** GOTO lbl21
            do {
                columnValues = resultMap.resolveSubMap(request, rs).getResults(request, rs);
                callback.handleResultObject(request, columnValues, rs);
                ++resultsFetched;
lbl21:
                // 2 sources

                if (maxResults != -999999 && resultsFetched >= maxResults) return;
            } while (rs.next());
            return;
        }
        finally {
            request.setResultSet(null);
        }
    }

    private static void closeStatement(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class Batch {
        private String currentSql;
        private List statementList = new ArrayList();
        private int size = 0;
        private static final int SUCCESS_NO_INFO = -2;
        private static final int EXECUTE_FAILED = -3;

        public int getSize() {
            return this.size;
        }

        public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
            PreparedStatement ps = null;
            if (this.currentSql != null && sql.hashCode() == this.currentSql.hashCode() && sql.length() == this.currentSql.length()) {
                int last = this.statementList.size() - 1;
                ps = (PreparedStatement)this.statementList.get(last);
            } else {
                ps = conn.prepareStatement(sql);
                this.currentSql = sql;
                this.statementList.add(ps);
            }
            request.getParameterMap().setParameters(request, ps, parameters);
            ps.addBatch();
            ++this.size;
        }

        public int executeBatch() throws SQLException {
            int totalRowCount = 0;
            int i = 0;
            int n = this.statementList.size();
            while (i < n) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                int[] rowCounts = ps.executeBatch();
                int j = 0;
                while (j < rowCounts.length) {
                    if (rowCounts[j] != -2) {
                        if (rowCounts[j] == -3) {
                            throw new SQLException("The batched statement at index " + j + " failed to execute.");
                        }
                        totalRowCount += rowCounts[j];
                    }
                    ++j;
                }
                ++i;
            }
            return totalRowCount;
        }

        public void cleanupBatch() {
            int i = 0;
            int n = this.statementList.size();
            while (i < n) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                SqlExecutor.closeStatement(ps);
                ++i;
            }
            this.currentSql = null;
            this.statementList.clear();
            this.size = 0;
        }
    }
}

