/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.binding.MapperProxy;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapClientImpl
implements ExtendedSqlMapClient {
    private static final Log log = LogFactory.getLog(SqlMapClientImpl.class);
    public SqlMapExecutorDelegate delegate;
    private ThreadLocal localSqlMapSession = new ThreadLocal();

    public SqlMapClientImpl(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public Object insert(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().insert(id, param);
    }

    public int update(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().update(id, param);
    }

    public int delete(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().delete(id, param);
    }

    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject);
    }

    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject, resultObject);
    }

    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject);
    }

    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject, skip, max);
    }

    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.getLocalSqlMapSession().queryForPaginatedList(id, paramObject, pageSize);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp, valueProp);
    }

    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandler(id, paramObject, rowHandler);
    }

    public void startTransaction() throws SQLException {
        this.getLocalSqlMapSession().startTransaction();
    }

    public void startTransaction(int transactionIsolation) throws SQLException {
        this.getLocalSqlMapSession().startTransaction(transactionIsolation);
    }

    public void commitTransaction() throws SQLException {
        this.getLocalSqlMapSession().commitTransaction();
    }

    public void endTransaction() throws SQLException {
        try {
            this.getLocalSqlMapSession().endTransaction();
        }
        finally {
            this.getLocalSqlMapSession().close();
        }
    }

    public void startBatch() throws SQLException {
        this.getLocalSqlMapSession().startBatch();
    }

    public int executeBatch() throws SQLException {
        return this.getLocalSqlMapSession().executeBatch();
    }

    public void setUserConnection(Connection connection) throws SQLException {
        this.getLocalSqlMapSession().setUserConnection(connection);
    }

    public Connection getUserConnection() throws SQLException {
        return this.getCurrentConnection();
    }

    public Connection getCurrentConnection() throws SQLException {
        return this.getLocalSqlMapSession().getCurrentConnection();
    }

    public DataSource getDataSource() {
        return this.getLocalSqlMapSession().getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public SqlMapSession openSession() {
        SqlMapSessionImpl sqlMapSession = this.getLocalSqlMapSession();
        sqlMapSession.open();
        return sqlMapSession;
    }

    public SqlMapSession openSession(Connection conn) {
        try {
            SqlMapSessionImpl sqlMapSession = this.getLocalSqlMapSession();
            sqlMapSession.open();
            sqlMapSession.setUserConnection(conn);
            return sqlMapSession;
        }
        catch (SQLException e) {
            throw new SqlMapException("Error setting user provided connection.  Cause: " + e, e);
        }
    }

    public SqlMapSession getSession() {
        log.warn("Use of a deprecated API detected.  SqlMapClient.getSession() is deprecated.  Use SqlMapClient.openSession() instead.");
        return this.openSession();
    }

    public void flushDataCache() {
        this.delegate.flushDataCache();
    }

    public void flushDataCache(String cacheId) {
        this.delegate.flushDataCache(cacheId);
    }

    public Object getMapper(Class c) {
        return MapperProxy.newMapperProxy(this, c);
    }

    private SqlMapSessionImpl getLocalSqlMapSession() {
        SqlMapSessionImpl sqlMapSession = (SqlMapSessionImpl)this.localSqlMapSession.get();
        if (sqlMapSession == null || sqlMapSession.isClosed()) {
            sqlMapSession = new SqlMapSessionImpl(this);
            this.localSqlMapSession.set(sqlMapSession);
        }
        return sqlMapSession;
    }
}

