/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicParameterMap
implements ParameterMap {
    private String id;
    private Class parameterClass;
    private ParameterMapping[] parameterMappings;
    private DataExchange dataExchange;
    private String resource;
    private Map parameterMappingIndex = new HashMap();
    private SqlMapExecutorDelegate delegate;

    public BasicParameterMap(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class parameterClass) {
        this.parameterClass = parameterClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public ParameterMapping[] getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappingList(List parameterMappingList) {
        this.parameterMappings = parameterMappingList.toArray(new BasicParameterMapping[parameterMappingList.size()]);
        int i = 0;
        while (i < this.parameterMappings.length) {
            this.parameterMappingIndex.put(this.parameterMappings[i].getPropertyName(), new Integer(i));
            ++i;
        }
        HashMap<String, BasicParameterMap> props = new HashMap<String, BasicParameterMap>();
        props.put("map", this);
        this.dataExchange = this.delegate.getDataExchangeFactory().getDataExchangeForClass(this.parameterClass);
        this.dataExchange.initialize(props);
    }

    public int getParameterIndex(String propertyName) {
        Integer idx = null;
        idx = (Integer)this.parameterMappingIndex.get(propertyName);
        return idx == null ? -1 : idx;
    }

    public int getParameterCount() {
        return this.parameterMappings.length;
    }

    public void setParameters(RequestScope request, PreparedStatement ps, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("applying a parameter map");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        errorContext.setMoreInfo("Check the parameter map.");
        if (this.parameterMappings != null) {
            int i = 0;
            while (i < this.parameterMappings.length) {
                BasicParameterMapping mapping = (BasicParameterMapping)this.parameterMappings[i];
                errorContext.setMoreInfo(mapping.getErrorString());
                if (mapping.isInputAllowed()) {
                    this.setParameter(ps, mapping, parameters, i);
                }
                ++i;
            }
        }
    }

    public Object[] getParameterObjectValues(RequestScope request, Object parameterObject) {
        return this.dataExchange.getData(request, this, parameterObject);
    }

    public CacheKey getCacheKey(RequestScope request, Object parameterObject) {
        return this.dataExchange.getCacheKey(request, this, parameterObject);
    }

    public void refreshParameterObjectValues(RequestScope request, Object parameterObject, Object[] values) {
        this.dataExchange.setData(request, this, parameterObject, values);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected void setParameter(PreparedStatement ps, BasicParameterMapping mapping, Object[] parameters, int i) throws SQLException {
        TypeHandler handler;
        Object value = parameters[i];
        String nullValueString = mapping.getNullValue();
        if (nullValueString != null && (handler = mapping.getTypeHandler()).equals(value, nullValueString)) {
            value = null;
        }
        TypeHandler typeHandler = mapping.getTypeHandler();
        if (value != null) {
            typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
        } else if (typeHandler instanceof CustomTypeHandler) {
            typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
        } else {
            int jdbcType = mapping.getJdbcType();
            if (jdbcType != -99999999) {
                ps.setNull(i + 1, jdbcType);
            } else {
                ps.setNull(i + 1, 1111);
            }
        }
    }
}

