/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AutoResultMap
extends BasicResultMap {
    public AutoResultMap(SqlMapExecutorDelegate delegate, boolean allowRemapping) {
        super(delegate);
        this.allowRemapping = allowRemapping;
    }

    public synchronized Object[] getResults(RequestScope request, ResultSet rs) throws SQLException {
        if (this.allowRemapping || this.getResultMappings() == null) {
            this.initialize(rs);
        }
        return super.getResults(request, rs);
    }

    private void initialize(ResultSet rs) {
        if (this.getResultClass() == null) {
            throw new SqlMapException("The automatic ResultMap named " + this.getId() + " had a null result class (not allowed).");
        }
        if (Map.class.isAssignableFrom(this.getResultClass())) {
            this.initializeMapResults(rs);
        } else if (this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()) != null) {
            this.initializePrimitiveResults(rs);
        } else if (DomTypeMarker.class.isAssignableFrom(this.getResultClass())) {
            this.initializeXmlResults(rs);
        } else {
            this.initializeBeanResults(rs);
        }
    }

    private void initializeBeanResults(ResultSet rs) {
        try {
            ClassInfo classInfo = ClassInfo.getInstance(this.getResultClass());
            String[] propertyNames = classInfo.getWriteablePropertyNames();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            int i = 0;
            while (i < propertyNames.length) {
                propertyMap.put(propertyNames[i].toUpperCase(), propertyNames[i]);
                ++i;
            }
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int i2 = 0;
            int n = rsmd.getColumnCount();
            while (i2 < n) {
                String columnName = rsmd.getColumnLabel(i2 + 1);
                String upperColumnName = columnName.toUpperCase();
                String matchedProp = (String)propertyMap.get(upperColumnName);
                if (matchedProp != null) {
                    BasicResultMapping resultMapping = new BasicResultMapping();
                    resultMapping.setPropertyName(matchedProp);
                    resultMapping.setColumnName(columnName);
                    resultMapping.setColumnIndex(i2 + 1);
                    Class type = classInfo.getSetterType(matchedProp);
                    resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(type));
                    resultMappingList.add(resultMapping);
                }
                ++i2;
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializeXmlResults(ResultSet rs) {
        try {
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 0;
            int n = rsmd.getColumnCount();
            while (i < n) {
                String columnName = rsmd.getColumnLabel(i + 1);
                BasicResultMapping resultMapping = new BasicResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(String.class));
                resultMappingList.add(resultMapping);
                ++i;
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializeMapResults(ResultSet rs) {
        try {
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 0;
            int n = rsmd.getColumnCount();
            while (i < n) {
                String columnName = rsmd.getColumnLabel(i + 1);
                BasicResultMapping resultMapping = new BasicResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(Object.class));
                resultMappingList.add(resultMapping);
                ++i;
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializePrimitiveResults(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            String columnName = rsmd.getColumnLabel(1);
            BasicResultMapping resultMapping = new BasicResultMapping();
            resultMapping.setPropertyName(columnName);
            resultMapping.setColumnName(columnName);
            resultMapping.setColumnIndex(1);
            resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()));
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            resultMappingList.add(resultMapping);
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }
}

