/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result.loader;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;

public class EnhancedLazyResultLoader {
    private static final Class[] INTERFACES = new Class[]{List.class};
    private Object loader;

    public EnhancedLazyResultLoader(ExtendedSqlMapClient client, String statementName, Object parameterObject, Class targetType) {
        this.loader = new EnhancedLazyResultLoaderImpl(client, statementName, parameterObject, targetType);
    }

    public Object loadResult() throws SQLException {
        return ((EnhancedLazyResultLoaderImpl)this.loader).loadResult();
    }

    private static class EnhancedLazyResultLoaderImpl
    implements InvocationHandler {
        protected ExtendedSqlMapClient client;
        protected String statementName;
        protected Object parameterObject;
        protected Class targetType;
        protected boolean loaded;
        protected Object resultObject;

        public EnhancedLazyResultLoaderImpl(ExtendedSqlMapClient client, String statementName, Object parameterObject, Class targetType) {
            this.client = client;
            this.statementName = statementName;
            this.parameterObject = parameterObject;
            this.targetType = targetType;
        }

        public Object loadResult() throws SQLException {
            if (DomTypeMarker.class.isAssignableFrom(this.targetType)) {
                return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            if (Collection.class.isAssignableFrom(this.targetType)) {
                return Enhancer.create(Object.class, (Class[])INTERFACES, (Callback)this);
            }
            if (this.targetType.isArray() || ClassInfo.isKnownType(this.targetType)) {
                return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            return Enhancer.create((Class)this.targetType, (Callback)this);
        }

        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if ("finalize".hashCode() == method.getName().hashCode() && "finalize".equals(method.getName())) {
                return null;
            }
            this.loadObject();
            if (this.resultObject != null) {
                try {
                    return method.invoke(this.resultObject, objects);
                }
                catch (Throwable t) {
                    throw ClassInfo.unwrapThrowable(t);
                }
            }
            return null;
        }

        private synchronized void loadObject() {
            if (!this.loaded) {
                try {
                    this.loaded = true;
                    this.resultObject = ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
                }
                catch (SQLException e) {
                    throw new NestedRuntimeException("Error lazy loading result. Cause: " + e, e);
                }
            }
        }
    }
}

