/*
 * Decompiled with CFR 0.152.
 */
package jxl.report;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.core.ExistMethodModel;
import freemarker.core.ExtendsDirective;
import freemarker.core.FormatDirective;
import freemarker.core.Utils;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FreemarkerHelper {
    private static Logger LOG = Logger.getLogger(FreemarkerHelper.class);
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static Configuration createConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setSharedVariable("extends", (TemplateModel)new ExtendsDirective());
        configuration.setSharedVariable("format", (TemplateModel)new FormatDirective());
        configuration.setSharedVariable("exist", (TemplateModel)new ExistMethodModel());
        return configuration;
    }

    public static TemplateLoader createTemplateLoader(String templatePath) throws IOException {
        String parent;
        File clsf;
        URL classUrl;
        if (templatePath == null) {
            return new ClassTemplateLoader(FreemarkerHelper.class, "/");
        }
        ArrayList<Object> loaders = new ArrayList<Object>();
        File curf = new File(templatePath);
        if (curf.exists()) {
            loaders.add(new FileTemplateLoader(curf));
            LOG.debug((Object)("load template from " + curf));
        }
        if ("file".equals((classUrl = FreemarkerHelper.class.getProtectionDomain().getCodeSource().getLocation()).getProtocol()) && (clsf = new File(parent = new File(classUrl.getPath()).getParent(), templatePath)).exists()) {
            loaders.add(new FileTemplateLoader(clsf));
            LOG.debug((Object)("load template from " + clsf));
        }
        loaders.add(new ClassTemplateLoader(FreemarkerHelper.class, templatePath));
        TemplateLoader[] lds = new TemplateLoader[loaders.size()];
        int i = 0;
        while (i < loaders.size()) {
            lds[i] = (TemplateLoader)loaders.get(i);
            ++i;
        }
        return new MultiTemplateLoader(lds);
    }

    public static StringWriter produceAsStringWriter(Map context, String templatePath, String templateName) throws TemplateException, IOException {
        return FreemarkerHelper.produceAsStringWriter(null, context, DEFAULT_ENCODING, templatePath, templateName, DEFAULT_ENCODING);
    }

    public static StringWriter produceAsStringWriter(Map context, String outEncoding, String templatePath, String templateName, String templateEncoding) throws TemplateException, IOException {
        return FreemarkerHelper.produceAsStringWriter(null, context, outEncoding, templatePath, templateName, templateEncoding);
    }

    public static StringWriter produceAsStringWriter(TemplateLoader loader, Map context, String outEncoding, String templatePath, String templateName, String templateEncoding) throws TemplateException, IOException {
        Configuration cfg = FreemarkerHelper.createConfiguration();
        if (loader == null) {
            cfg.setTemplateLoader(FreemarkerHelper.createTemplateLoader(templatePath));
        } else {
            cfg.setTemplateLoader(loader);
        }
        StringWriter writer = new StringWriter(1024);
        BufferedWriter bw = new BufferedWriter(writer);
        Template template = FreemarkerHelper.getTemplate(cfg, templateEncoding, templateName);
        Environment env = template.createProcessingEnvironment((Object)FreemarkerHelper.createContext(context), (Writer)bw);
        if (outEncoding != null) {
            env.setOutputEncoding(outEncoding);
        }
        env.process();
        bw.flush();
        String tempResult = writer.toString();
        if (tempResult != null && tempResult.trim().length() == 0) {
            LOG.debug((Object)"Generated output is empty.");
            return null;
        }
        return writer;
    }

    private static SimpleHash createContext(Map context) {
        SimpleHash ctx = new SimpleHash(ObjectWrapper.BEANS_WRAPPER);
        ctx.put("utils", (Object)new Utils());
        if (context != null) {
            for (Map.Entry element : context.entrySet()) {
                String key = (String)element.getKey();
                Object value = element.getValue();
                ctx.put(key, value);
            }
        }
        return ctx;
    }

    public static Template getTemplate(Configuration cfg, String encoding, String template) throws IOException {
        if (encoding == null) {
            return cfg.getTemplate(template);
        }
        return cfg.getTemplate(template, encoding);
    }

    public static void produce(Map context, File outFile, String templatePath, String templateName) throws IOException, TemplateException {
        FreemarkerHelper.produce(null, context, DEFAULT_ENCODING, outFile, templatePath, templateName, DEFAULT_ENCODING);
    }

    public static void produce(Map context, String outEncoding, File outFile, String templatePath, String templateName, String templateEncoding) throws IOException, TemplateException {
        FreemarkerHelper.produce(null, context, outEncoding, outFile, templatePath, templateName, templateEncoding);
    }

    public static void produce(TemplateLoader loader, Map context, String outEncoding, File outFile, String templatePath, String templateName, String templateEncoding) throws IOException, TemplateException {
        Configuration cfg = FreemarkerHelper.createConfiguration();
        if (loader == null) {
            cfg.setTemplateLoader(FreemarkerHelper.createTemplateLoader(templatePath));
        } else {
            cfg.setTemplateLoader(loader);
        }
        boolean ex = outFile.exists();
        FreemarkerHelper.ensureExistence(outFile);
        Template template = FreemarkerHelper.getTemplate(cfg, templateEncoding, templateName);
        Writer writer = null;
        try {
            writer = outEncoding == null ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), outEncoding));
            Environment env = template.createProcessingEnvironment((Object)FreemarkerHelper.createContext(context), writer);
            if (outEncoding != null) {
                env.setOutputEncoding(outEncoding);
            }
            env.process();
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {}
                writer.close();
            }
        }
        if (ex) {
            LOG.warn((Object)("Replace " + outFile.getAbsolutePath()));
        } else {
            LOG.info((Object)outFile.getAbsolutePath());
        }
    }

    private static void ensureExistence(File destination) {
        File dir = destination.getAbsoluteFile().getParentFile();
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeException("The path: " + dir.getAbsolutePath() + " exists, but is not a directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            if (dir.getName().equals(".") && dir.getParentFile().mkdirs()) {
                return;
            }
            throw new RuntimeException("unable to create directory: " + dir.getAbsolutePath());
        }
    }

    public static String produceAsString(Map context, String ftl) {
        return FreemarkerHelper.produceAsString(context, DEFAULT_ENCODING, ftl, DEFAULT_ENCODING);
    }

    public static String produceAsString(Map context, String outEncoding, String ftl, String templateEncoding) {
        try {
            String templateName = "stringTemplate";
            Configuration cfg = FreemarkerHelper.createConfiguration();
            StringTemplateLoader templateLoader = new StringTemplateLoader();
            templateLoader.putTemplate(templateName, ftl);
            cfg.setTemplateLoader((TemplateLoader)templateLoader);
            if (templateEncoding != null) {
                cfg.setDefaultEncoding(templateEncoding);
            }
            Template template = FreemarkerHelper.getTemplate(cfg, templateEncoding, templateName);
            StringWriter writer = new StringWriter(1024);
            Environment env = template.createProcessingEnvironment((Object)FreemarkerHelper.createContext(context), (Writer)writer);
            if (outEncoding != null) {
                env.setOutputEncoding(outEncoding);
            }
            env.process();
            return writer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)ftl);
            LOG.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

